/*

$Id: bgpcrack.h,v 1.6 2003/02/14 03:35:20 peloy Exp $

*/

#include <netinet/ip.h>
#include <openssl/md5.h>

#define TCPOPT_SIGNATURE 19 /* As defined in RFC2385 */

enum crack_modes {
	ONLINE_CRACK,
	OFFLINE_CRACK
};

struct options {
	enum crack_modes crack_mode;
	char *dumpfile;
	char *dictfile;
	char *rules_name;
	int segments_to_test;
	int delay;
	struct in_addr source_ip;
	struct in_addr destination_ip;
};

extern char *copy_argv(char **);
extern void dump(const unsigned char *data, unsigned len);
extern void error(int, const char *fmt, ...);
extern void debug(const char *fmt, ...);
extern void print_md5_digest(u_char *md5_digest);
extern MD5_CTX *tcp_sig(struct iphdr *ip, char *);
extern inline u_short in_cksum(void *data, int len);

extern char *program_name;
extern struct options options;
extern u_int32_t count; /* Number of tested packets */

