/*

$Id: util.c,v 1.4 2003/04/25 01:43:24 peloy Exp $

Part of tcphijack.

elparis@cisco.com

*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdarg.h>
#include <ctype.h>
#include <string.h>
#include <netinet/tcp.h>
#include <fcntl.h>
#include <sys/stat.h>

#include "tcphijack.h"
#include "util.h"

/*
 * Copy arg vector into a new buffer, concatenating arguments with spaces.
 * (stolen from tcpdump)
 */
char *
copy_argv(register char **argv)
{
	register char **p;
	register u_int len = 0;
	char *buf;
	char *src, *dst;

	p = argv;
	if (*p == 0)
		return 0;

	while (*p)
		len += strlen(*p++) + 1;

	buf = (char *)malloc(len);
	if (buf == NULL)
		error(1, "Couldn't allocate memory");

	p = argv;
	dst = buf;
	while ((src = *p++) != NULL) {
		while ((*dst++ = *src++) != '\0')
			;
		dst[-1] = ' ';
	}
	dst[-1] = '\0';

	return buf;
}

void dump(const unsigned char *data, unsigned len)
{
	unsigned i, j;

	for (i = 0; i <= len/16; i++) {
		printf("%08x  ", i*16);

		for (j = 0; j < 16; j++) {
			if (i*16 + j < len)
				printf("%02x", data[i*16 + j]);
			else
				printf("  ");

			if (j & 1)
				printf(" ");
		}

		for (j = 0; j < 16; j++)
			if (i*16 + j < len)
				printf("%c", isprint(data[i*16 + j]) ?
				       data[i*16 + j] : '.');

		printf("\n");
	}

	printf("\n");
}

/* VARARGS */
void
error(int eval, const char *fmt, ...)
{
	va_list ap;

	(void)fprintf(stderr, "%s: ", program_name);
	va_start(ap, fmt);
	(void)vfprintf(stderr, fmt, ap);
	va_end(ap);
	if (*fmt) {
		fmt += strlen(fmt);
		if (fmt[-1] != '\n')
			(void)fputc('\n', stderr);
	}
	exit(eval);
}

void debug(const char *fmt, ...)
{
#ifdef DEBUG
	va_list ap;

	va_start(ap, fmt);
	(void)vfprintf(stderr, fmt, ap);
	va_end(ap);
	if (*fmt) {
		fmt += strlen(fmt);
		if (fmt[-1] != '\n')
			(void)fputc('\n', stderr);
	}
#endif
}

inline u_short in_cksum(void *data, int len)
{
	int counter = len;
	u_short *w = data;
	int sum = 0;
	u_short tmp = 0;

	while (counter > 1) {
		sum += *w++;
		counter -= 2;
	}

	if (counter == 1) {
		/* Length is odd */
		*(u_char *) &tmp = *(u_char *) w;
		sum += tmp;
	}

	/* We want a 1's complement sum, so we must add whatever was
	   carried out from the low 16 bits to the low 16 bits */
	sum = (sum >> 16) + (u_short) sum;

	/* Add the carry from the previous sum */
	sum += sum >> 16;

	/* Now we take the 1's complement of the 1's complement sum */
	tmp = ~sum;

	return tmp;
}

/*
 * Just reads a file into memory. Stores pointer to data and length of
 * data in the payload structure.
 */
void read_payload(char *fname, struct payload *payload)
{
	int fd;
	struct stat file_stat;
	char *data;

	if ( (fd = stat(fname, &file_stat) ) == -1)
		error(1, "stat()");

	if ( (fd = open(fname, O_RDONLY) ) == -1)
		error(1, "open()");

	if ( (data = malloc(file_stat.st_size) ) == NULL) {
		close(fd);
		error(1, "malloc()");
	}

	if (read(fd, data, file_stat.st_size) == -1) {
		free(data);
		close(fd);
		error(1, "read()");
	}

	close(fd);

	payload->data = data;
	payload->len = file_stat.st_size;
}

/*
 * Just reads from stdin into memory. Stores pointer to data and length of
 * data in the payload structure.
 */
void read_payload_from_stdin(struct payload *payload)
{
	ssize_t bytes_read;
	char *buffer[4096];
	char *data;

	payload->len = 0;

	while ( (bytes_read = read(STDIN_FILENO, buffer, sizeof(buffer) ) ) ) {
		if ( (data = realloc(data, payload->len + bytes_read) ) == NULL)
			error(1, "realloc()");

		memcpy(data + payload->len, buffer, bytes_read);

		payload->len += bytes_read;
	}

	payload->data = data;
}

