/* **********************************************************************************
Copyright (c) 2009, MARK OSBORNE [LOUD-FAT-BLOKE.CO.UK] &
                    ALL RIGHTS RESERVED.

THIS SOFTWARE IS FREE TO USE FOR PRIVATE, NON-COMMERCIAL USE ONLY.
USE WITHIN ANY ORGANIZATION OR FOR COMMERCIAL PURPOSES IS PERMITTED ON THE CONDITION
THAT THE USE CAN BE DISCLOSED AS ADVERTISEMENT
   
THE FULL LICENSE AGREEMENT IS PROVIDED IN THE FILE NAMED  "LICENSE"
PROVIDED WITH THIS DISTRIBUTION.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.

****************************************************************************************/

int debug = 0;               // set to 1 for huge output 
                             // set to 2 for a gentle trace 
#define DEBUGIT(XXX)         if (debug != 0 ) printf("DEBUGIT: %s \n",XXX);
/*
/*
 *   OBESSIUS V7.1
*                  Is a new type of ddos detector
*                  It has proved very effective in real-file on
*                  Large Internet backbones see barometer.interoute.com
*
*                  It was designed to have most of the functionality ported 
*                  onto the WWW.CYBERSIFT.NET  advanced HANAC 10Gbe and 40GBE
*                  card but as everyone hasnt bought my product (YET!!!!)
*                  this is a LIBPCAP version that needs no special hardware
*                  or Linux  [ other than pcap ]
 */
int fd;
#include <fcntl.h>
#include <pcap.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#ifdef SNORT_LOG
#include <dirent.h>
#endif
#include <errno.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <time.h>
#include <unistd.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define __FAVOR_BSD
#include <netinet/ip.h>
#include <netinet/udp.h>
#include <netinet/tcp.h>

#include <sys/syslog.h>

/* default snap length (maximum bytes per packet to capture) */
#define SNAP_LEN_HDR  100
#define SNAP_LEN_FULL  1518

/* ethernet headers are always exactly 14 bytes [1] */
#define SIZE_ETHERNET 14

/* Ethernet addresses are 6 bytes */
#define ETHER_ADDR_LEN	6

/* SIGALRM durations */
#define ALARM_DUR0 5
#define ALARM_DUR1 10
#define ALARM_DUR2 15

/* 5% arbitrary capture to allow meaningful analysis */
#define SOME_PACKETS 500

/* Data file log */
#define DATA_FILE "/var/log/obeseus_data.log"

/* SYN, RST, ICMP & UDP flood log */
#define ALERT_FILE "/var/log/obeseus_alert.log"

/* File management */
#define TMPDIR "/tmp"
#define PREFIX "OBESS"
#define ANOMALY "ANOMA"

/* Compiler flag and variables for snort processing */
#ifdef SNORT_LOG
#define PROCESS "PROCC"
#define SN_PREFIX "SNORT"
#define SNORT_CMD "/usr/local/bin/snort -r"
#define SNORT_CMD2 "-c /probe_installed/obessiusv4/snort_instOB.conf -l"
#define SNORT_OP_ALERT "/tmp/alert.full.obessius"
#define SNORT_OP_DUMP "/tmp/dump.log.obessius"
#endif

/* Size of blacklist/aux array. */
#define BLK_NUM 2000
#define AUX_BLK_NUM 500

/* Maximum no repeated top subnets, arbitrary ignore value */
#define MAX_NO_24 3
#define IGNORE_24 1000

/* Ip string length */
#define IP_LEN 16

/* No. of consecutive SYNS/RST or SRC addresses. */
#define CONSEC_FLAGS 10

/* This defines the list of /24s to ignore for an attempt at ai */
#define BLACKLIST_FILE "/var/log/blacklist"
#define SUBNET_LEN 13
#define BLACK_LEN 21

/* Alert reliability */
#define GOOD_INDICATOR 20
#define STRONG_INDICATOR 30
#define STRONGER_INDICATOR 50
#define VERY_STRONG_INDICATOR 80
#define POSSIBLE 50
#define STRONG 70
#define VERY_STRONG 80

/* Loop delay */
#define FIVE_SECS 5

/* No activity timeout */
#define NO_ACTIVITY_SLEEP 180

/* Callback function pointer */
static void (*callback) (u_char*, const struct pcap_pkthdr*, const u_char*) = NULL;

/* Protos */
static int check_blacklist(uint32_t, int);

typedef struct 
{
	char subnet[SUBNET_LEN];
	int count;
} blktype;

typedef struct
{
	uint32_t qual;
	int count;
} qualtype;

/* Blacklist quick access array and stack num. */
static blktype blacklist[BLK_NUM];
static int blk_ptr = 0;

/*Auxiliary blacklist */
static blktype aux_blacklist[AUX_BLK_NUM];
static int aux_blk_ptr = 0;

/* Ethernet header */
struct sniff_ethernet {
        u_char  ether_dhost[ETHER_ADDR_LEN];    /* destination host address */
        u_char  ether_shost[ETHER_ADDR_LEN];    /* source host address */
        u_short ether_type;                     /* IP? ARP? RARP? etc */
};

#define IP_HL(ip)               (((ip)->ip_hl) & 0x0f)
#define IP_V(ip)                (((ip)->ip_hl) >> 4)

static void got_packet(u_char *args, const struct pcap_pkthdr *header, const u_char *packet);
static void count_proto(u_char proto);

 /* print help text
 */
void print_app_usage(void)
{
	printf("Usage: obeseus <i/f> ip");
	printf("\n");
  	printf("\n");

  	return;
}

char *dev = NULL;			/* pcap name */
#define  STAGE1_CAPTURE_SIZE 10000
#define  STAGE2_CAPTURE_SIZE 10000
#define  STAGE3_CAPTURE_SIZE 10000
#define  STAGE4_CAPTURE_SIZE 10000
#define  STAGE5_CAPTURE_SIZE 10000
#define TABLE_SIZE 10000

/* 1/1000 of the original table size to accomodate the
TOP_PC_DEC  and greater of all recorded address counts. */
#define TOP_PC_SIZE TABLE_SIZE/1000
/* Defines the top % of dest address counts to store.
Currently set at 40%, i.e top 60% are recorded. */ 
#define TOP_PC_DEC 0.4

/* Defines the minimum and reduction factor for count sizes. */
#define MIN_PC 0.1
#define QUAL_FACT 0.9

/* Defines for SYN/RST FLOOD attack */
/* Defines ratio of fins to syns/rsts.
 * Any less than this dictates a likely Synflood
 * Resetflood as the connection is imbalanced. */
#define SYN_FINRATE 0.85
#define RST_FINRATE 0.85
#define TWENTY_PERCENT_DEC 0.2

/* Defines for RST ICMP and UDP attacks */
#define FOURTY_PERCENT_DEC 0.4
#define SIXTY_PERCENT_DEC 0.6
#define EIGHTY_PERCENT_DEC 0.8

/* Probe unique id support */
#define HOSTLEN 20
#define UNQIDLEN 2

/* 12 hours in seconds */
#define TWELVE_HOURS 60 * 60 * 12

/* HTTP flood constants */
#define HTTP_GET "GET"
#define HTTP "HTTP"
#define NUM_IDENTS 4



#include "obes_parms.h"


static FILE* data_fptr = NULL;
static long tcp_cnt, udp_cnt, icmp_cnt; 
static int syn_cnt, ack_cnt, len_cnt, last_len, fin_cnt = 0;
static int rst_cnt = 0; 
static int rfc1918_cnt = 0;
static int http_flood_cnt = 0;
static int max_http_flood_cnt = 0;
static int band_ptr = 0;
static int band_top = 0;
static int prev_count = 0;
static size_t prev_time = 0;
static unsigned long prev_size;
static uint32_t table[TABLE_SIZE];
static uint32_t table_syn[TABLE_SIZE];
static uint32_t table_rst[TABLE_SIZE];
static signed short type_table[TABLE_SIZE];
static int table_cnt[TABLE_SIZE];
static int table_syn_cnt[TABLE_SIZE];
static int table_rst_cnt[TABLE_SIZE];
static int max_syn_cnt[TABLE_SIZE];
static int max_rst_cnt[TABLE_SIZE];
static int table_max_syn_cnt[TABLE_SIZE];
static int table_max_rst_cnt[TABLE_SIZE];
static int max_syns = 0;
static int max_rsts = 0;
static int max_packet_cnt = 0;
static int max_num_srcs = 0;
static int max_num_syn_srcs = 0;
static int max_num_rst_srcs = 0;
static int max_syn_packet_cnt = 0;
static int max_rst_packet_cnt = 0;
static unsigned long total_len = 0;
static unsigned long total_attack_count = 0;
static unsigned long length[TABLE_SIZE];
static unsigned short chksum[TABLE_SIZE];
static unsigned short chksumlen_cnt[TABLE_SIZE];
static unsigned short last_chksum = 0;
static unsigned long max_chksumlen_count = 0;
static float count_rate[MAX_NO_24];
static float size_rate[MAX_NO_24];
static uint32_t top_24_pc[TOP_PC_SIZE];
static int top_24_count = 0;            /* Holds no. subnets which qualify > TOP_PC_DEC */
static int top_24_pc_no = 0;            /* counter to process top % of 24 subnets */
static int top_srcip_count = 0;		/* Number of src addresses for this host */
uint32_t top_srcip_pc[TOP_PC_SIZE];	/* ip addr of the srcs */
qualtype rst_qualifiers[TOP_PC_SIZE];
qualtype syn_qualifiers[TOP_PC_SIZE];
qualtype src_qualifiers[TOP_PC_SIZE];	
static int count = 1;                   /* packet counter */
static int stage3_count = 0;            /* stage 3 packet count */
static int max_port_cnt, port_table_cnt[1000], port_table[1000];
static int max_port;
static int timeout = 0;
static int weighting = 0;
struct in_addr print_ip;  /*  address */
struct in_addr max_ip;  /* winner of the most popular dst  address */
static char errbuf[PCAP_ERRBUF_SIZE];          /* error buffer */
static pcap_t *handle;                         /* packet capture handle */
static char filter_exp[120] =  "\0                                                                      ";
char filter_port[30] = {""};
static char filter_proto[4] ={""};
static char max_ip_addr[IP_LEN] = {""};
static struct bpf_program fp;                  /* compiled filter program (expression) */
static bpf_u_int32 mask;                       /* subnet mask */
static bpf_u_int32 net;                        /* ip */
static pcap_dumper_t* dumpd = NULL;
static char tdate_buf[29] = {""};
static char* unqfnam = NULL;
static time_t current;
static time_t aux_blacklist_last = 0;
static int aux_blk_notify = 0;
static char unq_probe_id[UNQIDLEN] = {""};
static int failed_status = 0;
static int activity_latch = 0;
static char current_attack[22] = {""};
static char current_dst_addr[IP_LEN] ={""};
static time_t start_time = 0;
int flag_dec = 0;
int src_dec = 0;
int alert = 0;

/* Simple function to clean up unwated pcap logs. */
static remove_pcap(void)
{
	unlink(unqfnam);
	if (unqfnam != NULL)
		free(unqfnam);
	unqfnam = 0;
}

/* Function to report bandwidth stats. */
static void report_bandwidth(void)
{
	int i;
	long total_count = 0;
	long total_size = 0;
	FILE* alert_fptr = NULL;

	if (band_ptr > 0)
	{
		if (band_ptr == 1)
		{
			total_count = prev_count;
			total_size = prev_size;
		}
		else if (band_ptr > 1)
		{
			if (band_top != 0)
				band_ptr = band_top;

			for (i=1; i<=band_ptr; i++)
			{
				total_count += count_rate[i];
				total_size += size_rate[i];
				count_rate[i] = 0;
				size_rate[i] = 0;
			}
		}

		if (total_count > 0 && total_size > 0 && start_time > 0 && current > start_time)
		{
			alert_fptr = fopen(ALERT_FILE, "a+");

			if (alert_fptr != NULL)
			{
				float minutes = 0;
				float delta_time = (float)(current-start_time);
				minutes = (float)delta_time/60;

				fprintf(alert_fptr, "***%s ATTACK BANDWIDTH STATS--------------------------------------***\n", current_attack);
				if (minutes > 1.0)
					fprintf(alert_fptr, "%s attack complete duration was %3.2f minutes\n", current_attack, minutes);
				else
					fprintf(alert_fptr, "%s attack complete duration was %lu seconds\n", current_attack, current-start_time);
				fprintf(alert_fptr, "%s attack complete average size is %d bytes sec\n", current_attack, (int)total_size/band_ptr);
				fprintf(alert_fptr, "%s attack complete average count is %d packets sec\n", current_attack, (int)total_count/band_ptr);
				fprintf(alert_fptr, "***------------------------------------------------------------------***\n");
                       		fclose(alert_fptr);
			}
		}
		band_ptr = 0;
		band_top = 0;
		prev_time = 0;
		prev_size = 0;
		prev_count = 0;
		start_time = 0;
		total_attack_count = 0;
		total_len = 0;
		memset(current_attack, 0, 22);
		memset(current_dst_addr, 0, IP_LEN);
	}
}

/* Function to determine bandwidth of attack. */
static void calc_bandwidth(char* signature, char* dst_addr, int attack_count)
{
	if (signature != NULL && dst_addr != NULL)
	{
		if ((strstr(current_attack, signature) == NULL) ||
		     (strstr(current_dst_addr, dst_addr) == NULL))
		{
			if (strlen(current_attack) > 0)
				report_bandwidth();
			strcpy(current_attack, signature);
			strcpy(current_dst_addr, dst_addr);
 		}
		if (band_ptr > 0)
		{
			if (band_ptr == MAX_NO_24)
			{
				band_top = band_ptr;
				band_ptr = 0;
			}
			total_attack_count += attack_count;
			count_rate[band_ptr] = (float)((total_attack_count - prev_count)/(current - prev_time));
			size_rate[band_ptr] = (float)((total_len - prev_size)/(current - prev_time));
		}
		if (band_ptr == 0 && band_top == 0)
			start_time = current;

		prev_time = current;
                prev_count += attack_count;
                prev_size = total_len;
		band_ptr++;
	}
	else 
	{
		if (band_ptr > 0 && (strlen(current_attack) > 0))
			report_bandwidth();
		total_len = 0;
		total_attack_count = 0;
	}
}

/* This function initialises the blacklist array with data from the blacklist file.
*/
static void init_blacklist(void)
{
	FILE* blk_fptr = NULL;
	char read_buf[BLACK_LEN] = {""};
	char subnet[SUBNET_LEN] = {""};
	int blk_count = 0;
	int cnt = 0;

	if (access(BLACKLIST_FILE, R_OK) == 0)
	{
		blk_fptr = fopen(BLACKLIST_FILE, "r");

        	if (blk_fptr != NULL)
        	{
			blk_ptr = 0;
			while (blk_count<BLK_NUM)
			{
				memset(blacklist[blk_count].subnet, 0, SUBNET_LEN);
				blacklist[blk_count].count = 0;
				memset(read_buf, 0, BLACK_LEN);

                		if (fgets(read_buf, BLACK_LEN, blk_fptr) != NULL)
                		{
					memset(subnet, 0, SUBNET_LEN);
					cnt = 0;
					sscanf(read_buf, "%s %d", &subnet, &cnt);
					strncpy(blacklist[blk_count].subnet, subnet, SUBNET_LEN);
					blacklist[blk_count].count = cnt;
					blk_ptr++;
				}
				blk_count++;
			}
                	fclose(blk_fptr);
		}
	}
}

/* Update the blacklist file by removing it and generating a new 
 * one with the contents from the blacklist array 
*/
static void update_blacklist_file(void)
{
        FILE* blk_fptr = NULL;
	char writebuf[BLACK_LEN] = {""};
	int i;
	int subnet_size = 0;

	if (blk_ptr > 0)
	{
		/* Remove file if it exists */
        	if (access(BLACKLIST_FILE, R_OK) == 0)
			unlink(BLACKLIST_FILE);

        	blk_fptr = fopen(BLACKLIST_FILE, "w");

        	if (blk_fptr != NULL)
        	{
			for (i=0; i<blk_ptr; i++)
                	{
				/* If seen >= MAX_NO_24 times and not currently an ignore set to ignore */
				if (blacklist[i].count < IGNORE_24 && blacklist[i].count >= MAX_NO_24)
					blacklist[i].count = IGNORE_24;
				subnet_size = strlen(blacklist[i].subnet);
				if (blacklist[i].count > 0 && blacklist[i].subnet[subnet_size - 1] == '.')
                                {
                                        sprintf(writebuf, "%s %d\n", blacklist[i].subnet, blacklist[i].count);
                                        fprintf(blk_fptr, writebuf);
                                        memset(writebuf, 0, BLACK_LEN);
                                }
				subnet_size = 0;
			}
			fclose(blk_fptr);
		}
	}
}

/* Check the time and see if the aux blacklist needs clearing out. */
static void init_aux_blacklist(void)
{
	int i;

	if ((current - TWELVE_HOURS) > aux_blacklist_last)
	{
		for (i=0; i<AUX_BLK_NUM; i++)
		{
			aux_blacklist[i].count = 0;
			memset(aux_blacklist[i].subnet, 0, SUBNET_LEN);
		}
		aux_blk_ptr = 0;
		aux_blacklist_last = current;
		aux_blk_notify = 0;
	}
}
// OBV7 -  remove all the SNORT post processing
// OBV7 -   only an idea but not a good one    
//
/* Static function to rename the pcap dumps, (OBESS**), to 
 * PROCC** and then call Snort to process these logs against a 
 * specific rule set. If the Snort process matches the data signature
 * the pcap is renamed to SNORT** and the logs/alerts are uniquely named.
 * If not, the logs and alert files are removed and the pcap is renamed 
 * to ANOMA**, (ANOMAlies which need checking for new signatures).
 * (If Snort fails the PROCC** file is deleted).
*/
#ifdef SNORT_LOG
static void snort_process_log(void)
{

	int i = 0;
	int cpid = -1;
	char* file_ptr = NULL;
	char* snort_name = NULL;
	struct dirent* pdir = NULL;
	DIR *dirp = NULL;

	snort_name = (char*) malloc((sizeof(char)*strlen(unqfnam) + 1));
	memset(snort_name, 0, (strlen(unqfnam) + 1));
	strncpy(snort_name, unqfnam, (strlen(unqfnam) + 1));
	file_ptr = strstr(snort_name, PREFIX);

	/* Rename OBESS* file to PROCC* to avoid processing old OBESS* pcaps. */
	if (file_ptr != NULL)
	{
		strncpy(file_ptr, PROCESS, strlen(PROCESS));
		if (rename(unqfnam, snort_name) == -1)
		{
			syslog(LOG_ALERT, "%s Rename to %s failed\n", strerror(errno), snort_name);
			if (snort_name != NULL)
				free(snort_name);
                        return;
		}
	}
        
	dirp = opendir(TMPDIR);

	if (dirp != NULL)
	{
		while ((pdir = readdir(dirp)) != NULL)
		{
			if (strstr(pdir->d_name, PROCESS))
			{
				cpid = fork();
				if (cpid == 0)
				{
					int status = 0;
					int snort_cmd_size = 0;
					char* snort_cmd = NULL;
					char* snort_ptr = NULL;
					struct stat filestat;
					snort_cmd_size = (strlen(SNORT_CMD) + strlen(TMPDIR) + strlen(snort_name) + strlen(SNORT_CMD2) + strlen(TMPDIR) + 20);
					snort_cmd = (char*) malloc(sizeof(char)*snort_cmd_size);
					memset(snort_cmd, 0, snort_cmd_size);
					sprintf(snort_cmd, "%s %s/%s %s %s > /dev/null 2>&1", SNORT_CMD, TMPDIR, pdir->d_name, SNORT_CMD2, TMPDIR);
					system(snort_cmd);
						
					/* Check for an alert file as this should always be
					 * created upon a successfull Snort execution . */
					if (access(SNORT_OP_ALERT, R_OK) == 0)
					{
						char* res_snort_ptr = NULL;
						char* final_snort_name = NULL;
						char* snort_op_alert_name = NULL;
						char* snort_op_dump_name = NULL;
						int snort_op_alert_size = 0;
						int snort_op_dump_size = 0;
						int remove = 0;

						final_snort_name = (char*) malloc(sizeof(char)*(strlen(snort_name) + 1));
						memset(&filestat, 0, sizeof(filestat));
						memset(final_snort_name, 0, (strlen(snort_name) + 1));

						strncpy(final_snort_name, snort_name, (strlen(snort_name) + 1));
						snort_ptr = strstr(final_snort_name, PROCESS);

						/* If the alert file is empty, remove the alert
						 * and dump file and rename the file to ANOMA** */
						if (stat(SNORT_OP_ALERT, &filestat) == 0)
						{
							if (filestat.st_size == 0)
								remove = 1;
						}
						else
							remove = 1;
						
						/* Remove logs/alerts rename o/p to ANOMA**. */
						if (remove)
						{
							unlink(SNORT_OP_ALERT);
							if (access(SNORT_OP_DUMP, R_OK) == 0)
								unlink(SNORT_OP_DUMP);
							strncpy(snort_ptr, ANOMALY, strlen(ANOMALY));
						}
						else
						{
							snort_op_dump_size = strlen(SNORT_OP_DUMP) + (strlen(snort_name) + 1 - (strlen(TMPDIR) + strlen(SN_PREFIX)));
							/* Rename o/p to SNORT**. */
							strncpy(snort_ptr, SN_PREFIX, strlen(SN_PREFIX));
							snort_ptr+=strlen(SN_PREFIX);
							res_snort_ptr = snort_ptr;

							/* Make alert o/p uniquely referenced. */
							snort_op_alert_size = strlen(SNORT_OP_ALERT) + (strlen(snort_name) + 1 - (strlen(TMPDIR) + strlen(SN_PREFIX)));
							snort_op_alert_name = (char*) malloc(sizeof(char)*snort_op_alert_size);
							memset(snort_op_alert_name, 0, snort_op_alert_size);
							sprintf(snort_op_alert_name, "%s.%s", SNORT_OP_ALERT, snort_ptr);
							if (rename(SNORT_OP_ALERT, snort_op_alert_name) == -1)
								syslog(LOG_ALERT, "%s Rename to %s failed\n", strerror(errno), snort_op_alert_name);
							/* Make dump o/p uniquely referenced. */
							if (access(SNORT_OP_DUMP, R_OK) == 0)
							{
								snort_op_dump_size = strlen(SNORT_OP_DUMP) + (strlen(snort_name) + 1 - (strlen(TMPDIR) + strlen(SN_PREFIX)));
								snort_op_dump_name = (char*) malloc(sizeof(char)*snort_op_dump_size);
								memset(snort_op_dump_name, 0, snort_op_dump_size);
								sprintf(snort_op_dump_name, "%s.%s", SNORT_OP_DUMP, res_snort_ptr);
								if (rename(SNORT_OP_DUMP, snort_op_dump_name) == -1)
									syslog(LOG_ALERT, "%s Rename to %s failed\n", strerror(errno), snort_op_dump_name);
							}
						}
					
						if (rename(snort_name, final_snort_name) == -1)
							syslog(LOG_ALERT, "%s Rename to %s failed\n", strerror(errno), final_snort_name);
						if (snort_name != NULL)
							free(snort_name);
						if (final_snort_name != NULL)
							free(final_snort_name);
						if (snort_op_alert_name != NULL)
							free(snort_op_alert_name);
                                        	if (snort_op_dump_name != NULL)
							free(snort_op_dump_name);
						if (snort_cmd != NULL)
							free(snort_cmd);
						if (access(SNORT_OP_ALERT, R_OK) == 0)
							unlink(SNORT_OP_ALERT);
						if (access(SNORT_OP_DUMP, R_OK) == 0)
							unlink(SNORT_OP_DUMP);
						exit(EXIT_SUCCESS);
					}
					else
					{
						syslog(LOG_ALERT, "Call to %s failed\n", snort_cmd);
						if (snort_cmd != NULL)
							free(snort_cmd);
						if (access(snort_name, R_OK) == 0)
							unlink(snort_name);
						if (snort_name != NULL)
                                                        free(snort_name);
						exit(EXIT_FAILURE);
					}
				}
				else if (cpid > 0)
					break;
				else
				{
					syslog(LOG_ALERT, "%s Child Fork Snort failed\n",  strerror(errno));
					break;
				}
			}
		}
		closedir(dirp);
	}

	if (snort_name != NULL)
		free(snort_name);
	return;
}

#else

/* Static function to rename the OBESS* to ANOM* for processing by the perl script.*/
void rename_file(void)
{
	char* file_ptr = NULL;
	char* snort_name = NULL;

        snort_name = (char*) malloc((sizeof(char)*strlen(unqfnam) + 1));
        memset(snort_name, 0, (strlen(unqfnam) + 1));
        strncpy(snort_name, unqfnam, (strlen(unqfnam) + 1));
        file_ptr = strstr(snort_name, PREFIX);

	/* Rename OBESS* file to PROCC* to avoid processing old OBESS* pcaps. */
	if (file_ptr != NULL)
	{
		strncpy(file_ptr, ANOMALY, strlen(ANOMALY));
		if (rename(unqfnam, snort_name) == -1)
		{
			syslog(LOG_ALERT, "%s Rename to %s failed\n", strerror(errno), snort_name);
			if (snort_name != NULL)
				free(snort_name);
			return;
		}
	}
	else
		free(snort_name);
	
}
#endif

/* Static function to append a two digit unique identifier to the end
 * of the Unix timestamp for unique identification by the barometer. */
void add_probe_unqid (void)
{
        char host[HOSTLEN] = {""};
        int hostint = 0;
        int i;
        short int mod8 = 0;
        short int mod9 = 0;

        if ((gethostname(host, HOSTLEN)) != 0)
        {
                fprintf(data_fptr, "PLEASE NOTE: Get hostname failed, using random number\n");
                hostint = rand();
        }
        else
        {
                for (i=0; i<HOSTLEN; i++)
                        hostint += (int)host[i];
        }

        mod9 = hostint % 9;
        mod8 = hostint % 8;
        sprintf(unq_probe_id, "%d%d", mod9, mod8);
}

/* Trivial function to aid readability in output data file upon a continue condition. */
static void output_seperator(void)
{
        fprintf(data_fptr, "----------------------------------------------------------------------------  \n");
}

/* Static function to check that enough packets have been received for a meaningful analysis */
static int min_threshold_met(int stage)
{
	int threshold_met = 0;
	int local_count = 0;

	if (stage == 3)
		local_count = stage3_count;
	else
		local_count = count;	

	if (local_count <  PARM_min_capture_sample )
	{
		fprintf(data_fptr, "Minimum packet count of %d NOT met for Stage %d processing.\n",  PARM_min_capture_sample, stage);
		output_seperator();
	}	
	else
		threshold_met = 1;

	return threshold_met;	
}
/* Calculates modulo11 checksum of payload */
static unsigned short modulo11(const char* payload, int payload_size)
{
        int i;
        unsigned short chksum = 0;
        unsigned long sum = 0;

	if (payload != NULL && payload_size > 0)
	{
		for (i=0; i<=payload_size; i++)
                	sum += ((int)payload[i] * (i+2));
        	chksum = sum % 11;
	}
        return chksum;
}

/* Checks the contents of a recurring payload size */
static void check_http_url(const char* payload, int size_payload)
{

	int i = 0;
	int size_full_url = 0;
	int size_reduced_url = 0;
	unsigned short chksum = 0;
	char* start_pos = NULL;
	char* end_pos = NULL;
	char* full_url = NULL;
	char* loc = NULL;
	char* slash_pos = NULL;

	/* Find HTTP_GET in payload */
	if (strstr(payload, HTTP_GET) != NULL)
	{
		/* Find first backslash in payload */
		start_pos = strstr(payload, "/");
		if (start_pos != NULL)
		{
			end_pos = strstr(payload, HTTP);
			
			if (end_pos != NULL && end_pos > start_pos)
			{
				size_full_url = end_pos - start_pos;
				if (size_full_url <= size_payload)
				{
					full_url = (char*)malloc(sizeof(char)*size_full_url);
					strncpy(full_url, start_pos, size_full_url);
					/* Find last backslash in full_url */
					for (loc=end_pos; loc>start_pos; loc--)
					{
						if (*loc == '/')
						{
							slash_pos=++loc;
							break;
						}
					}
				
					/* If no slash is found, use start pos. */
					if (slash_pos == NULL)
						slash_pos = ++start_pos;
					size_reduced_url = end_pos - slash_pos;
					chksum = modulo11(slash_pos, size_reduced_url);
					if (chksum != last_chksum)
					{
						http_flood_cnt = 1;
						last_chksum = chksum;
					}
					else
					{
						http_flood_cnt++;
						if (http_flood_cnt > max_http_flood_cnt)
							max_http_flood_cnt = http_flood_cnt;
					}
					if (full_url != NULL)
						free(full_url);
				}
			}
		}
	}
	return;
}


/* Displays the address table for debugging purposes only */ 
void display_table()
{
	int n;

  	for (n = 0; n < TABLE_SIZE -1; n++) 
  	{
    		if (table[n] == 0 )
                 return ;
    		print_ip.s_addr = htonl(table[n]  << 8);
    		printf(" table n %i ",    table[n])  ;
    		printf("    %i      %s : %i \n", n,  inet_ntoa(  print_ip) , table_cnt[n] ) ;
  	}
  	return;
}

//OBV7 - added display_top_24 debug function
/* function print  TOP_PC_SIZE  src addresses. */
static void display_top_24()
{
        int i;

	for (i = 0; i < TOP_PC_SIZE; i++)
	{
	print_ip.s_addr = htonl( top_24_pc[i] << 8);
	/* For security */
	if (print_ip.s_addr == 0)
		return ;
	printf(" %s/24 \n", inet_ntoa(print_ip));
        }
}




/* Static function to pass back the top < TOP_PC_SIZE qualifying src addresses. */
static int generate_top_src_pc(qualtype* qualifiers, int enough)
{
        int i;
	int y = 0;
	int z;
	int pos;
	int status = 0;
	float qualify_cnt = 0;

	for (i = 0; i < TOP_PC_SIZE; i++)
	{
		qualifiers[i].qual = 0;
		qualifiers[i].count = 0;
        }

        /* Find values which qualify */
        for ( i = 0; i < TABLE_SIZE && y < TOP_PC_SIZE; i++)
        {
		if (table[i] != 0)
		{
			if (table_cnt[i] >= CONSEC_FLAGS)
			{
				qualifiers[y].qual = table[i];
				qualifiers[y].count = table_cnt[i];
				y++;
			}
		}
	}
//DOES THIS NEED FIXING as well

// answer = yes
	/* If not met, return -1. */
	if (y != 0     )
		return 0;
	else
		return -1;
}

/* Static function to check to see if >1 src address is available. */
static int check_src_addr(qualtype* src_qualifiers)
{
	int src_top_pc = 0;
	int swapped = 1;
	int i;
	int temp_cnt = 0;
	uint32_t temp_addr = 0;
	
	/* Check for a distributed attack. */
	if (max_num_srcs > PARM_min_attack_src_addr  )
	{
		while (swapped)
        	{
                	swapped = 0;
                	for (i=TABLE_SIZE; i>0; i--)
                	{
                        	if (table_cnt[i-1] < table_cnt[i])
                        	{
					temp_cnt = 0;
					temp_addr = 0;
        	                        temp_cnt = table_cnt[i-1];
					temp_addr = table[i-1];		
					table_cnt[i-1] = table_cnt[i];
					table[i-1] = table[i];
					table_cnt[i] = temp_cnt;
					table[i] = temp_addr;
					swapped = 1;
				}
			}
		}

		/* Now go through and find if there is more than 1 source address. */
		while(src_dec < TOP_PC_SIZE-1)
		{
//DOES THIS NEED FIXING as well
			src_top_pc = generate_top_src_pc(src_qualifiers, TOP_PC_SIZE-src_dec);
			if (src_top_pc == 0)
				return 1;
			src_dec++;
		}
	}
	return 0;
}

/* Static function to pass back the top TOP_PC_SIZE /24/addresses (uint32_t type), 
 * which have the highest qualifying count.
*/
static void generate_top_pc(uint32_t* storage, int* counter, int enough)
{
        int i;
	int y = 0;
	int z;
	int pos;
	int status = 0;
	int table_type = 5;
	float qualify_cnt = 0;

	qualtype qualifiers[TOP_PC_SIZE];

	qualify_cnt = (float)(max_packet_cnt * TOP_PC_DEC);
	
	/* Initialise */
	for (i = 0; i < TOP_PC_SIZE; i++)
	{
		qualifiers[i].qual = 0;
		qualifiers[i].count = 0;
        }

	while (y < enough)
	{
        	/* Find values which qualify */
        	for ( i = 0; i < TABLE_SIZE && y < TOP_PC_SIZE; i++)
        	{
			if ((float)table_cnt[i] >= qualify_cnt)
			{
				status = check_blacklist(table[i], 0);
                		if (status <= 1)
				{
                        		qualifiers[y].qual = table[i];
					qualifiers[y].count = table_cnt[i];
					table_cnt[i] = 0;
					y++;
				}
				if (status == 0)
					check_blacklist(table[i], 1);
			}
        	}
		
		if (y < enough)
		{
			qualify_cnt*=QUAL_FACT;
			if (qualify_cnt <= (float)(max_packet_cnt * MIN_PC))
				break;
		}
	}

	/* Sort and write the qualifiers */
        for ( i = 0; i < y; i++)
        {
		
		int largest = 0;
		for (z = 0; z < y; z++)
        	{
			if (qualifiers[z].count > largest)
			{
				largest = qualifiers[z].count;
				pos = z;
			}

		}
		qualifiers[pos].count = 0;
		storage[(*counter)++] = qualifiers[pos].qual;
        }
}

/* Alarm handler functions.
 * SigAlrmHandler performs cleaning up after a forced pcap loop timeout
 * has occurred. SigAlrmHandlerCount checks the packet count to see if
 * at least  PARM_min_capture_sample have been caught. 
 * If not it gives the process
 * another ALARM_DUR1 seconds. SigBucketHandler monitors the bucket
 * processing to exit in a controlled fashion if necessary.
*/
static void SigAlrmHandler(int signal)
{
    pcap_freecode(&fp);
    pcap_close(handle);
    timeout = 1;
    fprintf(data_fptr, "PLEASE NOTE: Packet capture was cut short due to timeout in PCAP\n");
}

static void SigAlrmHandlerCount(int sig)
{
    if (count >  PARM_min_capture_sample)
        SigAlrmHandler(sig);
    else
    {
        alarm(ALARM_DUR1);
        signal (SIGALRM, SigAlrmHandler);
    }    
}

static void SigBucketHandler(int signal)
{
	pcap_freecode(&fp);
    	pcap_close(handle);
	fprintf(data_fptr, "PLEASE NOTE: Bucket capture was cut short due to timeout in PCAP\n");
        output_seperator();
        fflush(data_fptr);
	failed_status = -1;
}

static void SigTrafficHandler(int signal)
{
	pcap_freecode(&fp);
    	pcap_close(handle);
        fprintf(data_fptr, "PLEASE NOTE: There is no traffic on the link, waiting for %d secs...\n", NO_ACTIVITY_SLEEP);
        output_seperator();
        fflush(data_fptr);
	sleep(NO_ACTIVITY_SLEEP);
	failed_status = -1;
}

/* Static function to report if the passed address falls within
 * the rfc 1918, (private VPN), range, meaning these are
*  definitely spoof. */
static int is_rfc1918(uint32_t x)
{
/*
10.0.0.0/8
*/
        if ((167772160 < x) && (x < 184549375))
                return 1;
/* 192.168
*/
        if ((3232235520   < x) && (x <  3232301055))
                return 1;
/*

172.32
*/
        if ((2886729728 < x) && (x <  2887843839))
                return 1;
/*
127.0.0.1 & 224.0.0.0

*/
        if (x == 2130706433)
                return 1;

        if (x == 3758096384 )
                return 1;

        if (x == 0)
                return 1;

        return 0;
}

/* Store the address counts. */
static void add_table(uint32_t passed_addr)
{
        int n;
        print_ip.s_addr =  passed_addr;

        for ( n = 0; n < TABLE_SIZE ; n++)
        {
                if ( table[n] == 0 )
                {
                        table[n] =  print_ip.s_addr;
                        table_cnt[n] = 1;
                        return;
                }
                if (table[n] == print_ip.s_addr)
                {
                        table_cnt[n]++;
                        if (table_cnt[n] >  max_packet_cnt)
                        {
                                max_ip.s_addr =  print_ip.s_addr;
                                max_packet_cnt = table_cnt[n];
                        }
                        return;
                }

        }
        return;
}

/* Store the address counts AND takes a u_char parameter to count sequential SYNs
 * This function is also used for counting src addresses for non SYN attacks, here
 * the SYN flag is set in the call to add_table_count */
static void add_table_count(uint32_t pass_addr, u_char th_flags)
{
        int n;
	int state = 4;
	struct in_addr pass_ip; 
        pass_ip.s_addr = pass_addr;

	if (pass_addr == 0)
		return;
	if (th_flags & TH_SYN)
		state = 6;
	else if (th_flags & TH_RST)
                state = 5; 

	/* Perform source address checking for SYN/RST/ANY flags. */
        for (n = 0; n < TABLE_SIZE; n++)
        {
                if (table[n] == 0)
                {
			table_cnt[n] = 1;
			max_num_srcs++;
			table[n] = pass_ip.s_addr;
			if (state == 6)
			{
				table_syn_cnt[n] = 1;
				max_syn_cnt[n] = table_syn_cnt[n];
				type_table[n] = state;
			}
			else if (state == 5)
                        {
                                table_rst_cnt[n] = 1;
                                max_rst_cnt[n] = table_rst_cnt[n];
				type_table[n] = state;
                        }
			else
				type_table[n] = 4;
                        return;
                }
                if (table[n] == pass_ip.s_addr)
                {
			table_cnt[n]++;
			if (state == 4)
			{
				table_syn_cnt[n] = 0;
				table_rst_cnt[n] = 0;
				type_table[n] = 4;
			}
			else if (type_table[n] != state)
			{
				if (state == 6)
				{
					table_syn_cnt[n] = 1;
					type_table[n] = 6;
				}
				else if (state == 5)
                                {
                                        table_rst_cnt[n] = 1;
					type_table[n] = 5;
                                }
                        }
                        else if (state == 6)
			{
				table_syn_cnt[n]++;
				if (table_syn_cnt[n] > max_syn_packet_cnt)
					max_syn_packet_cnt = table_syn_cnt[n];
				if (table_syn_cnt[n] >  max_syn_cnt[n])
				{
					max_syn_cnt[n] = table_syn_cnt[n];
					if (max_syn_cnt[n] == CONSEC_FLAGS)
						max_num_syn_srcs++;
				}

			}
			else if (state == 5)
			{
				table_rst_cnt[n]++;
				if (table_rst_cnt[n] > max_rst_packet_cnt)
					max_rst_packet_cnt = table_rst_cnt[n];
				if (table_rst_cnt[n] >  max_rst_cnt[n])
				{
					max_rst_cnt[n] = table_rst_cnt[n];
					if (max_rst_cnt[n] == CONSEC_FLAGS)
						max_num_rst_srcs++;
				}

			}
                        return;
		}
        }
	return;
}
// Function add_data_count()
/* Stores the payload length and checksum counts */
// OBV7  Function add_data_count() ammended to  count zero length payloads
static void add_data_count(unsigned short checksum, int len)
{
        int n=0;

       if (len == 0)
       {
		length[n] = len;
		chksum[n] = 0       ;
		chksumlen_cnt[n] =  chksumlen_cnt[n] + 1;
		if (chksumlen_cnt[n] > max_chksumlen_count)
			max_chksumlen_count = chksumlen_cnt[n];
		return;
	}
        for (n = 0; n < TABLE_SIZE; n++)
        {
                if (length[n] == 0)
                {
			length[n] = len;
			chksum[n] = checksum;
			chksumlen_cnt[n] = 1;
			return;
		}
                if (length[n] == len &&
			chksum[n] == checksum)
		{
			chksumlen_cnt[n]++;
			if (chksumlen_cnt[n] > max_chksumlen_count)
				max_chksumlen_count = chksumlen_cnt[n];
			return;
		}
        }
        return;
}

/* Store the port count. */
static void add_port_table( int passed_port )
{
	int n;
          
	for ( n = 0 ; n < 1000 -1 ; n++) 
     	{
     		if ( port_table[n] == 0 )
        	{
         		port_table[n] =  passed_port;
         		port_table_cnt[n] = 1;
         		return;
         	}
     		if (port_table[n] == passed_port)
        	{
         		port_table_cnt[n]++;
         		if ( port_table_cnt[n] >  max_port_cnt)
           		{
           			max_port =  passed_port;
           			max_port_cnt = port_table_cnt[n]; 
            		}
         		return ;
         	} 
      	} 
	return;
}

/* Log the protocol types. */
static void count_proto(u_char proto)
{
        /* determine protocol */
        switch(proto )
        {
                case IPPROTO_TCP:
                        tcp_cnt++;
                        break;
                case IPPROTO_UDP:
                        udp_cnt++;
                        break;
                case IPPROTO_ICMP:
                        icmp_cnt++;
                        break;
                default:
                        break;
        }

        if ( debug == 1)
        {
                printf(" Max packet count  tcp %u udp %u icmp %u  \n", tcp_cnt, udp_cnt,icmp_cnt );
        }

        return;
}

/* Adds/checks the blacklist. */
static int check_blacklist(uint32_t passed_sub, int modify)
{
        int i = 0;
	int size24 = 0;
	struct in_addr passed_subnet;
	char subnet_24[SUBNET_LEN] = {""};

	passed_subnet.s_addr = htonl(passed_sub << 8);
	memset(subnet_24, 0, SUBNET_LEN);
	sprintf(subnet_24, inet_ntoa(passed_subnet));

	/* Cut off last octet to make /24 */
	for(i=strlen(subnet_24); i>0; i--)
	{
		if (subnet_24[i] == '.')
		{
			size24 = ++i;
			break;
		}
	}
	
	if (modify == 0)
	{
		/* Check/update the blacklist */
        	for (i=0; i<blk_ptr; i++)
        	{
                	if (strncmp(blacklist[i].subnet, subnet_24, size24) == 0)
			{
				if (blacklist[i].count < MAX_NO_24)
				{
					blacklist[i].count++;
					return 1;
				}
				if (blacklist[i].count >= MAX_NO_24)
					return 2;
                	}
        	}

		/* Check/update the auxiliary blacklist */
		if (blk_ptr == BLK_NUM)
		{
			if (aux_blk_ptr == AUX_BLK_NUM)
			{
				if (aux_blk_notify < 3)
				{
					fprintf(data_fptr, "The auxilliary blacklist has reached its capacity of %d. Ignoring.\n", AUX_BLK_NUM);
					aux_blk_notify++;
				}
				return 1;
			}
			for (i=0; i<aux_blk_ptr; i++)
        		{
                		if (strncmp(aux_blacklist[i].subnet, subnet_24, size24) == 0)
                		{
                        		if (aux_blacklist[i].count < MAX_NO_24)
					{
						aux_blacklist[i].count++;
						return 1;
					}
                        		if (aux_blacklist[i].count >= MAX_NO_24)
						return 2;
				}
                	}
        	}
		return 0;
	}
	else
        {      
		if (BLK_NUM > blk_ptr)
		{
			memset(blacklist[blk_ptr].subnet, 0, SUBNET_LEN);
			strncpy(blacklist[blk_ptr].subnet, subnet_24, size24);
			blacklist[blk_ptr].count = 1;
			blk_ptr++;
        	}
		else if (blk_ptr == BLK_NUM)
		{
			fprintf(data_fptr, "The blacklist has reached its capacity of %d. Perhaps increase\n", BLK_NUM);
        		fprintf(data_fptr, "its size or review contents of %s.\n", BLACKLIST_FILE);
			
			if (aux_blk_ptr < AUX_BLK_NUM)
			{
				fprintf(data_fptr, "This address shall be written to the temporary blacklist which shall\n");
				fprintf(data_fptr, "be cleared out after 24 hours\n");
				memset(aux_blacklist[aux_blk_ptr].subnet, 0, SUBNET_LEN);
				strncpy(aux_blacklist[aux_blk_ptr].subnet, subnet_24, size24);
				aux_blacklist[aux_blk_ptr].count = 1;
				aux_blk_ptr++;
			}
		}
		return 0;
	}
	return 2;
}

/* Store the bucket count. */
void get_bucket(u_char *args, const struct pcap_pkthdr *header, const u_char *packet)
{
	/* declare pointers to packet headers */
	const struct sniff_ethernet *ethernet;  /* The ethernet header [1] */
	const struct ip *ip;        	        /* The IP header */

	int size_ip;
	int n;
 	uint32_t temp_addr;
	
	count++;

	/* define ethernet header */
	ethernet = (struct sniff_ethernet*)(packet);
	
	/* define/compute ip header offset */
	ip = (struct ip*)(packet + SIZE_ETHERNET);
	size_ip = IP_HL(ip)*4;
	if (size_ip < 20) 
	{
		fprintf(data_fptr, "Invalid IP header length: %u bytes\n", size_ip);
		return;
	}

	/* print source and destination IP addresses 
	*/
	if ( debug == 1)
	{
		printf("         To: %s\n", inet_ntoa(ip->ip_dst));
		printf("         frx %s\n", inet_ntoa(ip->ip_src));
	}
	fflush(0);

	/* If there is activity on the link, latch, clear ALARM_DUR0 alarm, set a PARM_pcap_loop_timeout 
	 * delay for SigBucketHandler and clear flags. */
	if (activity_latch == 0)
	{
		alarm(0);
		alarm(PARM_pcap_loop_timeout);
		signal (SIGALRM, SigBucketHandler);
		activity_latch = 1;
		failed_status = 0;
	}

	temp_addr = ntohl(ip->ip_dst.s_addr  ) ;
	temp_addr = temp_addr >> 8;
	add_table(temp_addr);
	return;
}

/* Get the address of the attack. */
static void got_packet(u_char *args, const struct pcap_pkthdr *header, const u_char *packet)
{
	
	/* declare pointers to packet headers */
	const struct sniff_ethernet *ethernet;  /* The ethernet header [1] */
	const struct ip *ip;                    /* The IP header */
	const struct tcphdr *tcp;               /* The TCP header */
	const char *payload;                    /* Packet payload */

	int size_ip;
	int size_tcp;
	int size_payload;
	int size_out;
	int n;
 	uint32_t temp_addr;
	
	count++;
	
	/* define ethernet header */
	ethernet = (struct sniff_ethernet*)(packet);
	
	/* define/compute ip header offset */
	ip = (struct ip*)(packet + SIZE_ETHERNET);
	size_ip = IP_HL(ip)*4;
	if (size_ip < 20)
	{
		fprintf(data_fptr, "Invalid IP header length: %u bytes\n", size_ip);
		return;
	}

	/* print source and destination IP addresses 
	*/
	if (debug == 1)
	{
		printf("         To: %s\n", inet_ntoa(ip->ip_dst));
	}
 	temp_addr = ntohl(ip->ip_dst.s_addr); 

	add_table(temp_addr);
        return;
}

/* Dissect the ip attack. */
void get_ip_attack(u_char *args, const struct pcap_pkthdr *header, const u_char *packet)
{	
	/* declare pointers to packet headers */
	const struct sniff_ethernet *ethernet;  /* The ethernet header [1] */
	const struct ip *ip;                    /* The IP header */
	const struct tcphdr *tcp;               /* The TCP header */
        const struct udphdr *udp;               /* The udp  header */

	const char *payload;                    /* Packet payload */

	int size_ip;
	int size_tcp;
	int size_payload;
	int n;
 	uint32_t temp_addr;

	stage3_count++;
	
	/* define ethernet header */
	ethernet = (struct sniff_ethernet*)(packet);
	
	/* define/compute ip header offset */
	ip = (struct ip*)(packet + SIZE_ETHERNET);
	size_ip = IP_HL(ip)*4;
	if (size_ip < 20) 
	{
		if (debug == 1)
			printf("   * Invalid IP header length: %u bytes\n", size_ip);
		return;
	}

	/* Total length for bandwidth calcs. */
	total_len = ip->ip_len;

	/* Print valid ip packets to temp log file */
        pcap_dump((u_char *)dumpd, header, packet);

	/* determine protocol */	
	count_proto(ip->ip_p) ;

	return;
}

/* Dissect the tcp attack. */
void get_tcp_attack(u_char *args, const struct pcap_pkthdr *header, const u_char *packet)
{
	/* declare pointers to packet headers */
	const struct sniff_ethernet *ethernet;  /* The ethernet header [1] */
	const struct ip *ip;                    /* The IP header */
	const struct tcphdr *tcp;               /* The TCP header */
	const char *payload;                    /* Packet payload */
	int size_payload;
	int size_ip;
	int size_tcp;
	int n;
 	uint32_t temp_addr;
	uint32_t src_addr;
	
	count++;
	
	/* define ethernet header */
	ethernet = (struct sniff_ethernet*)(packet);
	
	/* define/compute ip header offset */
	ip = (struct ip*)(packet + SIZE_ETHERNET);
	size_ip = IP_HL(ip)*4;
	if (size_ip < 20) {
		printf("   * Invalid IP header length: %u bytes\n", size_ip);
		return;
	}

	/* determine protocol */	
	switch(ip->ip_p) 
	{
		case IPPROTO_TCP:
			break;
		case IPPROTO_UDP:
                        if (debug == 1)
				printf("   Protocol: UDP - but i am in get_tcp_attack\n");
                        return;
	
		default:
			if (debug == 1)
			{
				printf("   Protocol: unknown-skipping");
				printf("    - but i am in get_tcp_attack\n");
			}
			return;
	}
	
	/*
	 *  OK, this packet is TCP.
	 */
	
	/* define/compute tcp header offset */
	tcp = (struct tcphdr*)(packet + SIZE_ETHERNET + size_ip);
	size_tcp = tcp->th_off*4;
	
	if (size_tcp < 20) 
	{
		printf("   * Invalid TCP header length: %u bytes\n", size_tcp);
		return;
	}
        if ( debug == 1 )
        {
        	/* print source and destination IP addresses */
		printf("       From: %s\n", inet_ntoa(ip->ip_src));
		printf("         To: %s\n", inet_ntoa(ip->ip_dst));
        	/* print source and destination ports         
	 	* */
        	printf("sport dport %i %i ",
                        ntohs(tcp->th_sport)  ,
	                ntohs(tcp->th_dport));
        }

	/* Print valid tcp packets to temp log file */
	pcap_dump((u_char *)dumpd, header, packet);
	
	/* define/compute tcp payload (segment) offset */
	payload = (u_char *)(packet + SIZE_ETHERNET + size_ip + size_tcp);

	/* compute tcp payload (segment) size */
	size_payload = ntohs(ip->ip_len) - (size_ip + size_tcp);
	
	if (size_payload > 0)
	{
		/* Store payload sizes and checksums */
		add_data_count(modulo11(payload, size_payload), size_payload);

		/* Check the payload for repeated GETs and a fixed URL. */
		check_http_url(payload, size_payload);
	}

	/*    detect a syn flood */
	if (tcp->th_flags & TH_SYN)
		syn_cnt++;
	/*    detect a rst  flood */
	if (tcp->th_flags & TH_RST)
    		rst_cnt++;
        /*    count ack packets */ 
        if (tcp->th_flags & TH_ACK)
                ack_cnt++;
        if (tcp->th_flags & TH_FIN)
                fin_cnt++;

	/* Update the src address list for this capture. */
	add_table_count(ip->ip_src.s_addr, tcp->th_flags);
	
	/* look for spoof src add */
	src_addr = ntohl(ip->ip_src.s_addr);
	rfc1918_cnt = rfc1918_cnt + is_rfc1918(src_addr);

	return;
}

/*
 * dissect udp attack  
 */
        
void get_udp_attack(u_char *args, const struct pcap_pkthdr *header, const u_char *packet)
{
	/* declare pointers to packet headers */
	const struct sniff_ethernet *ethernet;  /* The ethernet header [1] */
	const struct ip *ip;                    /* The IP header */
        const struct udphdr *udp;               /* The udp  header */
	const char *payload;                    /* Packet payload */
	int size_payload;
	int size_ip;
	int n;
 	uint32_t src_addr;
	
	count++;
	
	/* define ethernet header */
	ethernet = (struct sniff_ethernet*)(packet);
	
	/* define/compute ip header offset */
	ip = (struct ip*)(packet + SIZE_ETHERNET);
	size_ip = IP_HL(ip)*4;
	if (size_ip < 20) 
	{
		if (debug == 1)
			printf("   * Invalid IP header length: %u bytes\n", size_ip);
		return;
	}

	/* determine protocol */	
	switch(ip->ip_p) 
	{
		case IPPROTO_TCP:
                        if (debug == 1)
				printf("   Protocol: TCP - but i am in get_udp_attack\n");
			return;
		case IPPROTO_UDP:
			break;
	
		default:
			if (debug == 1)
			{
				printf("   Protocol: unknown-skipping");
				printf("    - but i am in get_tcp_attack\n");
                        }
			return;
	}

	/*
	 *  OK, this packet is UDP.
	 */
	udp  = (struct udphdr*)(packet + SIZE_ETHERNET + size_ip);

	/* Print valid udp packets to temp log file */
        pcap_dump((u_char *)dumpd, header, packet);

	/* define/compute udp payload (segment) offset */
        payload = (u_char *)(packet + SIZE_ETHERNET + size_ip + 8);	
	
	/* compute udp payload (segment) size */
        size_payload = ntohs(ip->ip_len) - (size_ip + 8);

	/* Store payload sizes and checksums */
	if (size_payload > 0)
		add_data_count(modulo11(payload, size_payload), size_payload);
	else
		add_data_count(0, size_payload);

        if ( debug == 1 )
        {
        	/* print source and destination IP addresses */
		printf("       From: %s\n", inet_ntoa(ip->ip_src));
		printf("         To: %s\n", inet_ntoa(ip->ip_dst));
        	/* print source and destination ports         
	 	* */
        	printf("sport dport %i %i ", ntohs(udp->uh_sport), ntohs(udp->uh_dport));
        }
	
	/* Update the src address list for this capture.
	 * Use 0 as a parameter to force 'other' collection. */
	add_table_count(ip->ip_src.s_addr, 0);

	/* look for spoof src add */
	src_addr = ntohl(ip->ip_src.s_addr);
	rfc1918_cnt = rfc1918_cnt + is_rfc1918(src_addr);

	return;
}

/* Determine port count. */
void get_port_attack(u_char *args, const struct pcap_pkthdr *header, const u_char *packet)
{	
	/* declare pointers to packet headers */
	const struct sniff_ethernet *ethernet;  /* The ethernet header [1] */
	const struct ip *ip;                    /* The IP header */
	const struct tcphdr *tcp;               /* The TCP header */
        const struct udphdr *udp;               /* The udp  header */

	const char *payload;                    /* Packet payload */

	int size_ip;
	int size_tcp;
	int size_payload;
	int size_out;
	int n;
 	uint32_t temp_addr;
		
	count++;

	
	/* define ethernet header */
	ethernet = (struct sniff_ethernet*)(packet);
	
	/* define/compute ip header offset */
	ip = (struct ip*)(packet + SIZE_ETHERNET);
	size_ip = IP_HL(ip)*4;
	if (size_ip < 20) 
	{
		printf("   * Invalid IP header length: %u bytes\n", size_ip);
		return;
	}
	/* timestamp bollock */
	switch(ip->ip_p) {
		case IPPROTO_TCP:
		case IPPROTO_UDP:
			break;
	
		case IPPROTO_ICMP:
			if (debug == 1)
			{
				printf("   Protocol: ICMP\n");
				printf("   should not get here \n");
			}
                        return; 
	
		default:
			if (debug == 1)
			{
				printf("   Protocol: unknown-skipping\n");
				printf("   should not get here \n");
			}
                        return; 
	}
	
	/*
	 *  OK, this  packet is TCPi or udp - assume udp .
	 */
	
	/* define/compute tcp header offset */
	udp  = (struct udphdr*)(packet + SIZE_ETHERNET + size_ip);
        /* print source and destination IP addresses 
	 * */

	if (debug == 1 )
        	printf("src port  %i dest port %i \n", ntohs(udp->uh_sport), ntohs(udp->uh_dport));
	/* find the most common port              */
	add_port_table(ntohs(udp->uh_dport));
 
	return;
}

/* Static function to build and compile the filter */
static int pcap_build_filter(void)
{
	/*compile the filter expression */
	if (pcap_compile(handle, &fp, filter_exp, 0, net) == -1) {
		fprintf(data_fptr, "Couldn't parse filter %s: %s..\n",
		    filter_exp, pcap_geterr(handle));
		return -1;
	}

	/* apply the compiled filter */
	if (pcap_setfilter(handle, &fp) == -1) 
	{
		fprintf(data_fptr, "Couldn't install filter %s: %s..\n", filter_exp, pcap_geterr(handle));
		return -1;
	}
	return 0;
}

/* Static function to add more telementry assertion nto the alert process. */
static char* report_strength(int weighting)
{
        if (weighting < GOOD_INDICATOR)
                return "";
        else if (weighting >= GOOD_INDICATOR && weighting < POSSIBLE)
                return "POSSIBLE";
        else if (weighting >= POSSIBLE && weighting < STRONG)
                return "STRONG_POSSIBLE";
        else if (weighting >= STRONG && weighting < VERY_STRONG)
                return "STRONG";
        else if (weighting >= VERY_STRONG)
                return "VERY_STRONG";
        else
                return "";
}


/* Static function to check for a ping flood attack */
static int is_pingflood(void)
{
        static FILE* alert_fptr = NULL;
	char icmp_report[135] = {""};
	char signature[22] = {""};
	float caughtrate = 0;
        float pingrate = 0;
	int pingflood = 0;

	/* Protect from div by 0 */
	if (stage3_count == 0)
		return;

	caughtrate = (float) stage3_count / PARM_stage3_capture_size;
	pingrate = (float) icmp_cnt / stage3_count ;
	
	/* Rule 1 */
	if (caughtrate > PARM_icmp_capture_rate )
	{
		/* Rule 2 */
		if (pingrate > PARM_icmp_2other_protos_rate)
			weighting += VERY_STRONG_INDICATOR;

		/* Strength Qualifier */
		if (weighting > PARM_icmp_overall_weighting )
        	{
			sprintf(icmp_report, "%s PINGFLOOD ATTACK DETECTED - status done - id %lu%s - Target Host %s",  report_strength(weighting), current, unq_probe_id, inet_ntoa(print_ip));
			fprintf(data_fptr, icmp_report);
			fprintf(data_fptr, "\nNo of packets packets with ICMP flag set is %d out of %d captured\n", icmp_cnt, stage3_count);
			fprintf(data_fptr, "This equates to a PING packet percentage of %d%%\n", (int)(pingrate * 100)) ;

			openlog("obessius", LOG_ODELAY, LOG_LOCAL0);
			syslog(LOG_ALERT, icmp_report);
			closelog();
		
			/* Open the alert log file */
			alert_fptr = fopen(ALERT_FILE, "a+");

			if (alert_fptr != NULL)
			{
				strcat(icmp_report, "\n");
				fprintf(alert_fptr, icmp_report);
				fprintf(alert_fptr, "PCAP DUMP FOR THIS ALERT IS: %s\n", unqfnam);
				fclose(alert_fptr);
			}
			pingflood = 1;
			sprintf(signature, "PING %d%s", current, unq_probe_id);
			calc_bandwidth(signature, inet_ntoa(print_ip), stage3_count);
		}
	}
	
	return pingflood;
}


/* Static function to check for a udp flood attack */
static int is_udpflood(void)
{
        static FILE* alert_fptr = NULL;
        char udp_report[157] = {""};
	char src_addrs[260] = {""};
	char attacked[23] = {""};
	char signature[22] = {""};
	float udprate = 0;
        float rfc1918_rate = 0;
	float chksumlen_rate = 0;
	int udpflood = 0;
	int i;

	struct in_addr src_ip;

	/* Protect from div by 0 */
        if (stage3_count == 0 || count == 0)
                return;

	udprate = (float)  udp_cnt / stage3_count ;
	rfc1918_rate = (float)  rfc1918_cnt / count ;

	/* Rule 1 */
	if (udprate > PARM_udpflood_rate )
		weighting += GOOD_INDICATOR;
	/* Rule 2 */
	if (rfc1918_rate > PARM_udpflood_rfc1918_rate )
                weighting += STRONGER_INDICATOR;
	/* Rule 3 */
	chksumlen_rate = (float) (max_chksumlen_count / count);
	if (chksumlen_rate > PARM_udpflood_chksumlen_rate)
		weighting += STRONG_INDICATOR;

	/* Strength Qualifier */
	if (weighting >= PARM_udpflood_overall_weighting)
	{
		/* Reset the src qualifiers. */
		memset(src_qualifiers, 0, sizeof(qualtype)*TOP_PC_SIZE);
		/* Check for > 1 src address. */
		if (check_src_addr(src_qualifiers) == 1)
		{
			sprintf(udp_report, "%s UDPFLOOD ATTACK DETECTED - status done - id %lu%s - Target Host %s Target Proto: %s Port: %d",  report_strength(weighting), current, unq_probe_id, inet_ntoa(print_ip), filter_proto, max_port);
			fprintf(data_fptr, udp_report);
			fprintf(data_fptr, "\nNo of packets with UDP flag set is %d out of %d captured\n", udp_cnt, stage3_count);
			fprintf(data_fptr, "This equates to a UDP FLOOD packet percentage of %d%%\n", (int)(udprate * 100)) ;
			fprintf(data_fptr, "RFC1918 spoof packet percentage of %d%%\n", (int)(rfc1918_rate * 100)) ;
			fprintf(data_fptr, "Matching checksum and length packet percentage of %d%%\n", (int)(chksumlen_rate * 100));

			/* Concat into a string. */
			sprintf(src_addrs, "UDPFLOOD TOP IPS - status done - id %lu%s - %d top UDP src addresses ", current, unq_probe_id, TOP_PC_SIZE-src_dec);
                        
			/* Update the message. */
			for (i=0; i<TOP_PC_SIZE; i++)
			{
				if ( src_qualifiers[i].count == 0 )
                                              break ;
// check for overrun
				if (i > (( sizeof(src_addrs) - 100) / 16) )
                                              break ;
				src_ip.s_addr = src_qualifiers[i].qual;
				strcat(src_addrs, inet_ntoa(src_ip));
				strcat(src_addrs, " ");
			}
			sprintf(attacked, "attacking Port: %d\n", max_port);
			strcat(src_addrs, attacked);

			openlog("obessius", LOG_ODELAY, LOG_LOCAL0);
			syslog(LOG_ALERT, udp_report);
			syslog(LOG_ALERT, src_addrs);
			closelog();

			/* Open the alert log file */
			alert_fptr = fopen(ALERT_FILE, "a+");

			if (alert_fptr != NULL)
			{
				strcat(udp_report, "\n");
				fprintf(alert_fptr, udp_report);
				fprintf(alert_fptr, src_addrs);
				fprintf(alert_fptr, "PCAP DUMP FOR THIS ALERT IS: %s\n", unqfnam);
				fclose(alert_fptr);
			}
			udpflood = 1;
			sprintf(signature, "UDP %d%s", current, unq_probe_id);
			calc_bandwidth(signature, max_ip_addr, udp_cnt);
        	}
	}
	return udpflood;
}

/* Static function to pass back the top < TOP_PC_SIZE SYN src addresses. */
//   generate_top_syn_pc()
//  routine goes thru max_syn tables if the count is greater than CONSEC_FLAG
//  it moves it into the qualifiers struct table 
//  if  none are  above CONSEC_FLAG returns an error
static int generate_top_syn_pc(qualtype* qualifiers, int enough)
{
        int i;
	int y = 0;
DEBUGIT("generate_top_syn_pc")

	for (i = 0; i < TOP_PC_SIZE; i++)
	{
		qualifiers[i].qual = 0;
		qualifiers[i].count = 0;
        }

        /* Find values which qualify */
        for ( i = 0; i < max_syns+1 && y < TOP_PC_SIZE; i++)
        {
		if (max_syn_cnt[i] >= CONSEC_FLAGS)
		{
			qualifiers[y].qual = table_syn[i];
			qualifiers[y].count = max_syn_cnt[i];
			y++;
		}
	}
////OBV7.1  no just give' em what you got 


	/* If not met, return -1. */
	if (y != 0    )
		return 0;
	else
		return -1;
}

/* Checks to see if >1 CONSEC_FLAGS SYN src address are available. */
static int check_syn_src_addr(qualtype* syn_qualifiers)
{
DEBUGIT("CHECK_SYN_SRC_ADDR")
	int swapped = 1;
	int syn_top_pc = -1;
	int i = 0;
	int temp_cnt = 0;
	uint32_t temp_addr = 0;
	
	/* Only process if top address SYN count determines it. */
	if (max_syn_packet_cnt >= CONSEC_FLAGS)
	{
		/* Firstly, extract the SYNs into tables. */
		for (i=0; i<TABLE_SIZE; i++)
		{
			if ( table[i] != 0 && type_table[i] & 0x02)
			{
				table_syn[max_syns] = table[i];
				table_max_syn_cnt[max_syns] = max_syn_cnt[i];
				max_syns++;
			}
		}
	}

	max_syns--;

	/* Now, sort the max_syn_count and max_rst_cnt tables. */
	if (max_syns > 1)
	{
		while (swapped)
		{
			swapped = 0;
			for (i=max_syns; i>0; i--)
			{
        	                if (table_max_syn_cnt[i-1] < table_max_syn_cnt[i])
                	        {
					temp_cnt = table_max_syn_cnt[i-1];
					temp_addr = table_syn[i-1];
					table_max_syn_cnt[i-1] = table_max_syn_cnt[i];
					table_syn[i-1] = table_syn[i];
                                	table_syn[i] = temp_addr;
					table_max_syn_cnt[i] = temp_cnt;
                                	swapped = 1;
					temp_cnt = 0;
					temp_addr = 0;
				}
			}		
		}
	}

syn_top_pc  = generate_top_syn_pc(syn_qualifiers, TOP_PC_SIZE- 1      );
if (syn_top_pc == 0)
	return 1;
return 0;

//OBV7.1 This is some kinda sick hill-climbing routine 
////OBV7.1  to   try and fill the table 
////OBV7.1  would be great if it works 

	/* Now go through the SYNS. */
	if (max_syns > 1)
	{
		while(flag_dec < TOP_PC_SIZE-1)
		{
			syn_top_pc = generate_top_syn_pc(syn_qualifiers, TOP_PC_SIZE-flag_dec);
			if (syn_top_pc == 0)
				return 1;
			flag_dec++;
		}
	}
	return 0;
}


/* Static function to check for a SYN flood attack */
static int is_synflood(void)
{
DEBUGIT("IS_SYNFLOOD")
	static FILE* alert_fptr = NULL;
	char syn_report[190] = {""};
	char src_addrs[260] = {""};
	char src_addrs_1[260] = {""};    // need this silly var cos I buggered up the rportin
	char attacked[23] = {""};
	char signature[22] = {""};
	float synrate = 0;
        float finrate = 0;
	float syn_finrate = 0;
	float rfc1918_rate = 0;
	int i;
	int synflood = 0;

	struct in_addr src_ip;

	/* Protect from div by 0 */
        if (count == 0 )
                return;

// OBV7 		Early versions ignored all attacks If only one source address  
// OBV7 		for the attack (DDOS not DoS)     
// OBV7 		makes this check optional controlled parms        
	/* Only perform processing if > 1 src addr with > CONSEC_FLAGS consec syns. */
	if (max_num_syn_srcs >  PARM_min_attack_src_addr)
	{
 		synrate = (float)  syn_cnt / count;
		finrate = (float)  fin_cnt / count;
		rfc1918_rate = (float)  rfc1918_cnt / count;	

		if (synrate > 0.0 && finrate > 0.0)
			syn_finrate = (float) finrate / synrate;

		/* Rule 1 */
	      	if (synrate > PARM_synflood_syn_rate )
		{
			weighting += STRONG_INDICATOR;
			/* Rule 2 */
			if (syn_finrate < PARM_synflood_syn_finrate )
				weighting += STRONGER_INDICATOR;
		}
		/* Rule 3 */
		if (rfc1918_rate > PARM_synflood_rfc1918_rate )
                	weighting += GOOD_INDICATOR;

		/* Strength Qualifier */
		if (weighting >= PARM_synflood_overall_weighting )
		{
			/* Reset the syn qualifiers. */
			memset(syn_qualifiers, 0, sizeof(qualtype)*TOP_PC_SIZE);
			sprintf(syn_report, "%s SYNFLOOD ATTACK DETECTED - status done - id %lu%s  - Target Host %s Target Proto: %s Port: %d", report_strength(weighting), current, unq_probe_id, max_ip_addr, filter_proto ,max_port );
			fprintf(data_fptr, syn_report);
			/* Check for any number of address with more than CONSEC_FLAG  syns. */
			if (check_syn_src_addr(syn_qualifiers) == 1)
		//	if (                               1   == 1)
			{
				fprintf(data_fptr, "\nNo of packets with SYN flag set is %d out of %d captured\n", syn_cnt, count);
				fprintf(data_fptr, "This equates to a SYN packet percentage of %d%%\n", (int)(synrate * 100));
	        	        fprintf(data_fptr, "Percentage of SYNs to FINs %d%%\n", (int)(syn_finrate * 100));
				fprintf(data_fptr, "RFC1918 spoof packet percentage of %d%%\n", (int)(rfc1918_rate * 100));

////OBV7.1  prepare a loop thru the whole table 
////OBV7.1  escape if it gets a count of zero 
				for (i=0; i<TOP_PC_SIZE; i++)
				{
					if ( syn_qualifiers[i].count == 0 )
                                              break ;
// check for overrun
				if (i > (( sizeof(src_addrs) - 100) / 16) )
                                              break ;
					src_ip.s_addr = syn_qualifiers[i].qual;
					strcat(src_addrs, inet_ntoa(src_ip));
					strcat(src_addrs, " ");
				}
				/* Concat into a string.  buggered about to save addresses */
				strcpy(src_addrs_1,src_addrs);
				sprintf(src_addrs, "SYNFLOOD TOP IPS - status done - id %lu%s - %d top SYN src addresses ", current, unq_probe_id, i);
				strcat(src_addrs, src_addrs_1);
				/* Update the message. */
				sprintf(attacked, "attacking Port: %d\n", max_port);
				strcat(src_addrs, attacked);

				openlog("obessius", LOG_ODELAY, LOG_LOCAL0);
				syslog(LOG_ALERT, syn_report);
				syslog(LOG_ALERT, src_addrs);
				closelog();

				/* Open the alert log file */
				alert_fptr = fopen(ALERT_FILE, "a+");

				if (alert_fptr != NULL)
				{
					strcat(syn_report, "\n");
					fprintf(alert_fptr, syn_report);
					fprintf(alert_fptr, src_addrs);
					fprintf(alert_fptr, "PCAP DUMP FOR THIS ALERT IS: %s\n", unqfnam);
	        	        	fclose(alert_fptr);
				}
				synflood = 1;
				sprintf(signature, "SYN %d%s", current, unq_probe_id);
				calc_bandwidth(signature, max_ip_addr, syn_cnt);
			}
		      else
				fprintf(data_fptr, "\nNo further details reported - no address produce %d sequential syns\n" , CONSEC_FLAGS); 
		}
	}
	weighting = 0;
	flag_dec = 0;
	return synflood;
}

/* Static function to pass back the top < TOP_PC_SIZE RST src addresses. */
//  generate_top_rst_pc()
//  routine goes thru max_rst tables if the count is greater than CONSEC_FLAG
//  it moves it into the qualifiers struct table 
//  if  none are  above CONSEC_FLAG returns an error
static int generate_top_rst_pc(qualtype* qualifiers, int enough)
{
DEBUGIT("GENERATE_TOP_RST_PC")
        int i;
	int y = 0;
	int z;

	for (i = 0; i < TOP_PC_SIZE; i++)
	{
		qualifiers[i].qual = 0;
		qualifiers[i].count = 0;
        }

        /* Find values which qualify */
        for ( i = 0; i < max_rsts + 1  && y < TOP_PC_SIZE; i++)
        {
		if (max_rst_cnt[i] >= CONSEC_FLAGS)
		{
			qualifiers[y].qual = table_rst[i];
			qualifiers[y].count = max_rst_cnt[i];
			y++;
		}
	}
////OBV7.1  no just give' em what you got 

	/* If none, return -1. */
	if (y != 0 )
		return 0;
	else
		return -1;
}

/* Checks to see if >1 CONSEC_FLAGS RST src address is available. */
static int check_rst_src_addr(qualtype* rst_qualifiers)
{
DEBUGIT("IS_CHECK_RST_SRC_ADDR")
	int rst_top_pc = -1;
	int swapped = 1;
	int i = 0;
	int temp_cnt = 0;
	uint32_t temp_addr = 0;
	
	/* Only process if top address RST count determines it. */
	if (max_rst_packet_cnt >= CONSEC_FLAGS)
	{
		/* Firstly, extract the RSTs into tables. */
		for (i=0; i<TABLE_SIZE; i++)
		{
			if (table[i] != 0 && type_table[i] & 0x01)
			{
				table_rst[max_rsts] = table[i];
				table_max_rst_cnt[max_rsts] = max_rst_cnt[i];
				max_rsts++;
			}
		}
	}

	max_rsts--;

	if (max_rsts > 1)
	{
		while (swapped)
		{
			swapped = 0;
			for (i=max_rsts; i>0; i--)
			{
                        	if (table_max_rst_cnt[i-1] < table_max_rst_cnt[i])
                        	{
					temp_cnt = table_max_rst_cnt[i-1];
					temp_addr = table_rst[i-1];
					table_max_rst_cnt[i-1] = table_max_rst_cnt[i];
					table_rst[i-1] = table_rst[i];
                                	table_rst[i] = temp_addr;
					table_max_rst_cnt[i] = temp_cnt;
                                	swapped = 1;
					temp_cnt = 0;
					temp_addr = 0;
				}
                        }
		}
	}
 	rst_top_pc = generate_top_rst_pc(rst_qualifiers, TOP_PC_SIZE - 1);
	if (rst_top_pc == 0)
		return 1;
	return 0;
//OBV7.1 This is some kinda sick hill-climbing routine 
//OBV7.1  to   try and fill the table 
//OBV7.1  would be great if it works 
//OBV7.1  it dont so just brnach out (ABOVE) before with what we got 
	
	/* Now go through and RSTS. */
	if (max_rsts > 1)
	{
		while(flag_dec < TOP_PC_SIZE-1)
		{
			rst_top_pc = generate_top_rst_pc(rst_qualifiers, TOP_PC_SIZE-flag_dec);
			if (rst_top_pc == 0)
				return 1;
			flag_dec++;
		}
	}
	return 0;
}


/* Static function to check for a RESET flood attack */
static int is_resetflood(void)
{
DEBUGIT("IS_RESETFLOOD")
        static FILE* alert_fptr = NULL;
        char rst_report[190] = {""};
	char src_addrs[260] = {""};
	char src_addrs_1[260] = {""};    // need this silly var cos I buggered up the rportin
	char attacked[23] = {""};
	char signature[22] = {""};
	float rstrate = 0;
        float rfc1918_rate = 0;
        int i;
	int resetflood = 0;

	struct in_addr src_ip;

        /* Protect from div by 0 */
        if (count == 0 )
                return;

// OBV7 		Early versions ignored all attacks If only one source address  
// OBV7 		for the attack (DDOS not DoS)     
// OBV7 		makes this check optional controlled parms        
	/* Only perform processing if > 1 src addr with > CONSEC_FLAGS consec rsts. */
	if (max_num_rst_srcs > PARM_min_attack_src_addr )
	{
        	rstrate = (float) rst_cnt / count;
	        rfc1918_rate = (float)  rfc1918_cnt / count;

		weighting = 0;

	        /* Rule 1 */
        	if (rstrate >  PARM_rstflood_rst_rate)
                	weighting = STRONGER_INDICATOR;

	        /* Rule 2 */
        	if (rfc1918_rate > PARM_rstflood_rfc1918_rate)
                	weighting += GOOD_INDICATOR;

		/* Strength Qualifier */
		if (weighting > PARM_rstflood_overall_weighting)
		{
			/* Reset the rst qualifiers. */
			memset(rst_qualifiers, 0, sizeof(qualtype)*TOP_PC_SIZE);
	               	sprintf(rst_report, "%s RESETFLOOD ATTACK DETECTED - status done - id %lu%s  - Target Host %s Target Proto: %s Port: %d", report_strength(weighting), current, unq_probe_id, max_ip_addr, filter_proto ,max_port );
			fprintf(data_fptr, rst_report);
			/* Check if any  rst src address have count gt CONSEQ_FLAG. */
			if (check_rst_src_addr(rst_qualifiers) == 1)
			{
				fprintf(data_fptr, "\nNo of packets with RST flag set is %d out of %d captured\n", rst_cnt, count);
				fprintf(data_fptr, "This equates to a RST packet percentage of %d%% \n", (int)(rstrate * 100));
fprintf(data_fptr, rst_report);
	                	fprintf(data_fptr, "RFC1918 spoof packet percentage of %d%%\n", (int)(rfc1918_rate * 100));

////OBV7.1  prepare a loop thru the whole table 
////OBV7.1  escape if it gets a count of zero 
				for (i=0; i<TOP_PC_SIZE; i++)
				{
					if ( rst_qualifiers[i].count == 0 )
                                              break ;
// check for overrun
				if (i > (( sizeof(src_addrs) - 100) / 16) )
                                              break ;
					src_ip.s_addr = rst_qualifiers[i].qual;
					strcat(src_addrs, inet_ntoa(src_ip));
					strcat(src_addrs, " ");
				}
				/* Concat into a string.  buggered about to save addresses */
				strcpy(src_addrs_1,src_addrs);
				sprintf(src_addrs, "RESETFLOOD TOP IPS - status done - id %lu%s - %d top RST src addresses ", current, unq_probe_id, i);
				strcat(src_addrs, src_addrs_1);
				/* Update the message. */
				sprintf(attacked, "attacking Port: %d\n", max_port);
				strcat(src_addrs, attacked);

				openlog("obessius", LOG_ODELAY, LOG_LOCAL0);
				syslog(LOG_ALERT, rst_report);
				syslog(LOG_ALERT, src_addrs);
				closelog();

				/* Open the alert log file */
				alert_fptr = fopen(ALERT_FILE, "a+");

				if (alert_fptr != NULL)
				{
					strcat(rst_report, "\n");
					fprintf(alert_fptr, rst_report);
					fprintf(alert_fptr, src_addrs);
					fprintf(alert_fptr, "PCAP DUMP FOR THIS ALERT IS: %s\n", unqfnam);
					fclose(alert_fptr);
				}

				resetflood = 1;
				sprintf(signature, "RESET %d%s", current, unq_probe_id);
				calc_bandwidth(signature, max_ip_addr, rst_cnt);
			}
		      else
				fprintf(data_fptr, "\nNo further details reported - no address produce %d sequential rsts\n" , CONSEC_FLAGS); 
        	}
	}
	flag_dec = 0;
	weighting = 0;
	return resetflood;
}
/* Static function to check for a HTTP flood attack. */
static int is_httpflood(void)
{
DEBUGIT("IS_HTTPFLOOD")
        static FILE* alert_fptr = NULL;
        char pay_report[190] = {""};
	char signature[22] = {""};
	float flood_rate = 0;
	char src_addrs[260] = {""};
	char attacked[23] = {""};
        float rfc1918_rate = 0;
	float chksumlen_rate = 0;
        int i;
	int httpflood = 0;

	struct in_addr src_ip;

        /* Protect from div by 0 */
        if (count == 0 )
                return;
	
	weighting = 0;

	flood_rate = (float) max_http_flood_cnt / count;
	chksumlen_rate = (float) max_chksumlen_count / count;

	/* Rule 1 */
	if (flood_rate > PARM_http_strong_flood_rate)
	{
		if (flood_rate > PARM_http_verystrong_flood_rate )
			weighting = VERY_STRONG_INDICATOR;
		else if (flood_rate > PARM_http_stronger_flood_rate )
			weighting = STRONGER_INDICATOR;
		else
			weighting = STRONG_INDICATOR;
	}
	/* Rule 2 */
        if (rfc1918_rate >  PARM_http_rfc1918_rate )
                weighting += GOOD_INDICATOR;
	/* Rule 3 */
	if (chksumlen_rate > PARM_http_chksumlen_rate )
                weighting += GOOD_INDICATOR;

	/* Strength Qualifier */
        if (weighting >= PARM_http_overall_weighting)
	{
		/* Reset the src qualifiers. */
		memset(src_qualifiers, 0, sizeof(qualtype)*TOP_PC_SIZE);
		/* Check for > 1 src address. */
		if (check_src_addr(src_qualifiers) == 1)
		{
			sprintf(pay_report, "%s HTTPFLOOD ATTACK DETECTED - status done - id %lu%s  - Target Host %s Target Proto: %s Port: %d", report_strength(weighting), current, unq_probe_id, max_ip_addr, filter_proto, max_port);
			fprintf(data_fptr, pay_report);
			fprintf(data_fptr, "\nNo of packets with identical mod11 urls is %d out of %d captured\n", max_http_flood_cnt, count);
			fprintf(data_fptr, "This equates to an identical mod11 url packet percentage of %d%%\n", (int)(flood_rate * 100));
			fprintf(data_fptr, "RFC1918 spoof packet percentage of %d%%\n", (int)(rfc1918_rate * 100));
			fprintf(data_fptr, "Matching checksum and length packet percentage of %d%%\n", (int)(chksumlen_rate * 100));

			/* Concat into a string. */
			sprintf(src_addrs, "HTTPFLOOD TOP IPS - status done - id %lu%s - %d top HTTP src addresses ", current, unq_probe_id, TOP_PC_SIZE-src_dec);
			/* Update the message. */
			for (i=0; i<TOP_PC_SIZE-src_dec; i++)
			{
				src_ip.s_addr = src_qualifiers[i].qual;
				strcat(src_addrs, inet_ntoa(src_ip));
				strcat(src_addrs, " ");
			}
			sprintf(attacked, "attacking Port: %d\n", max_port);
			strcat(src_addrs, attacked);

			openlog("obessius", LOG_ODELAY, LOG_LOCAL0);
			syslog(LOG_ALERT, pay_report);
			syslog(LOG_ALERT, src_addrs);
			alert_fptr = fopen(ALERT_FILE, "a+");

			if (alert_fptr != NULL)
			{
				strcat(pay_report, "\n");
				fprintf(alert_fptr, pay_report);
				fprintf(alert_fptr, src_addrs);
				fprintf(alert_fptr, "PCAP DUMP FOR THIS ALERT IS: %s\n", unqfnam);
				fclose(alert_fptr);
	                }
			httpflood = 1;
			sprintf(signature, "%s %d%s", "HTTP", current, unq_probe_id);
			calc_bandwidth(signature, max_ip_addr, max_http_flood_cnt);
        	}
	}
	return httpflood;
}


/* Simple static function to reset re-used data */
void reset_counts(void)
{
DEBUGIT("RESET_COUNTS")
	/* Memsets */
	memset(table_cnt, 0, TABLE_SIZE);
	memset(max_syn_cnt, 0, TABLE_SIZE);
	memset(max_rst_cnt, 0, TABLE_SIZE);
	memset(type_table, 0, TABLE_SIZE);
        memset(table, 0, TABLE_SIZE);
	memset(table_syn, 0, TABLE_SIZE);
	memset(table_rst, 0, TABLE_SIZE);
	memset(table_syn_cnt, 0, TABLE_SIZE);
	memset(table_rst_cnt, 0, TABLE_SIZE);
 	memset(chksum, 0, TABLE_SIZE);
	memset(chksumlen_cnt, 0, TABLE_SIZE);
        memset(length, 0, TABLE_SIZE);
  	memset(port_table_cnt, 0, 1000);
        memset(port_table, 0, 1000);              
	memset(max_ip_addr, 0, IP_LEN);
	memset(filter_exp, 0, 120);
	memset(top_srcip_pc, 0, TOP_PC_SIZE);
	memset(unq_probe_id, 0, UNQIDLEN);

	/* Counters */
        count = 0;
        max_packet_cnt = 0;
	max_num_srcs = 0;
	max_num_syn_srcs = 0;
	max_num_rst_srcs = 0;
	max_rst_packet_cnt = 0;
	max_syn_packet_cnt = 0;
	max_syns = 0;
	max_rsts = 0;
        max_port_cnt = 0;
	rfc1918_cnt = 0;
        tcp_cnt = 0;
        icmp_cnt = 0;
        syn_cnt = 0;
        rst_cnt = 0;
        ack_cnt = 0;
	http_flood_cnt = 0;
	max_http_flood_cnt = 0;
	max_chksumlen_count = 0;
	last_chksum = 0;
	top_srcip_count = 0;
	weighting = 0;
	flag_dec = 0;
	src_dec = 0;
	alert = 0;
	failed_status = 0;
	activity_latch = 0;

	/* Ptr to func */
	callback = NULL;
}

/* Process the top buckets */
int process_buckets(void)
{
DEBUGIT("PROCESS_BUCKETS")
	alarm(ALARM_DUR0);
	signal (SIGALRM, SigTrafficHandler);
	pcap_loop(handle, (int) PARM_stage1_capture_size, get_bucket, NULL);
	alarm(0);  // cancel   alarm  immediately 6/2010 
 	
	/* If the bucket count timed out with no traffic or didn't complete in the 
	 * allotted time, clean up and try again, otherwise clear the alarm and continue. */
        if (failed_status == -1)
                return -1;
	else
		alarm(0);
	if (debug == 1)
		display_table();
	memset(top_24_pc,0,TOP_PC_SIZE);

        /* Sort the full list of subnets from the bucket into a top
        % of TOP_PC_SIZE buffer based on count popularity. */
        generate_top_pc(top_24_pc, &top_24_count, 4);
	if (debug == 1)
            display_top_24();

        /* cleanup */
        pcap_freecode(&fp);
        pcap_close(handle);

	/* If no qualifying buckets, return -1. */
	if (top_24_count == 0)
	{
		fprintf(data_fptr, "PLEASE NOTE: There are no /24s that qualify and are NOT in blacklist...\n");
		output_seperator();
		fflush(data_fptr);
		sleep(FIVE_SECS);
		return -1;
	}
	
	return 0;
}

/* This function processed the packets and hence finds the top talking ip
 * for the specific bucket.
*/
int process_packets(void)
{
DEBUGIT("PROCESS_PACKETS")
	reset_counts();
	strcpy(filter_proto, "");
	strcpy(filter_port, "");

	fprintf(data_fptr, "Stage 2 Find top talking host ip for this bucket..........\n") ;
	print_ip.s_addr = htonl( top_24_pc[top_24_pc_no] << 8);
	/* For security */
	if (print_ip.s_addr == 0)
        {
	        fprintf(data_fptr, "IP address in top talking host Rtable corrupt..........\n") ;
		return -1;
        } 
	/*  build a BPF */
	sprintf(filter_exp ,"dst net %s/24 ", inet_ntoa(print_ip));
	fprintf(data_fptr, "DST NET: Apply filter :%s  \n",  filter_exp);

        handle = pcap_open_live(dev, SNAP_LEN_HDR, 1, 10, errbuf);
        if (handle == NULL)
        {
        	fprintf(data_fptr, "Couldn't open file, %s: %s, continuing..\n", dev, errbuf);
                return -1;
        }

        /* Compile the filter expression */
        if (pcap_build_filter() == -1)
		return -1;

        /* Set an alarm for PARM_pcap_loop_timeout seconds and setup
        * the handler, (to prevent hanging issues) */
        alarm(PARM_pcap_loop_timeout);
        signal (SIGALRM, SigAlrmHandlerCount);

	/* Now we can set our callback function. */
	pcap_loop(handle, (int) PARM_stage2_capture_size,  got_packet, NULL);
	alarm(0);  // cancel   alarm  immediately 6/2010 

	if (timeout == 0)
	{
		/* cleanup */
		alarm(0);
		pcap_freecode(&fp);
		pcap_close(handle);
        }
        else
		timeout = 0;
	
	print_ip.s_addr = htonl( max_ip.s_addr );
	return 0;
}



#define CONF_FILE "OB.conf"
//          get_config(void)
/* This function reads the parameter file and set appropriate vars                 
*/
static void get_config(void)
{
DEBUGIT("GET_CONFIG")
	FILE* conf_fptr = NULL;
	char read_buffy[80] = {""};
	char item[80] = {""};
	float cnt = 0;

	int x= 0; 
	if (access(CONF_FILE, R_OK) != 0)
	{
		 fprintf(data_fptr,"cant open conf file - use defaults ");
		return ;
	}
	conf_fptr = fopen(CONF_FILE, "r");

       	if (conf_fptr == NULL)
       	{
		 fprintf(data_fptr,"cant open conf file - use defaults ");
		return ;
 	}
	while ( 1 == 1 )                    
	{
		if (debug == 1)
			printf("DEBUGIT: %50s\n", read_buffy);
		memset(read_buffy, 0, 80 );

                   
        	if (fgets(read_buffy, 80, conf_fptr) == NULL)
		{
			 fprintf(data_fptr,"end of file                    \n  ");
               		break;
 		} 
	       	if ( read_buffy[0] == '#') 
                       	continue;

		if ( x = sscanf(read_buffy, "%s %f", &item  , &cnt) != 2)
		{
			fprintf(data_fptr,"Parm error - show line and exiti %i \n",x);
			fprintf(data_fptr,"error line: %50s\n", read_buffy);
			exit(1);
		}
                if ( strcmp(item, "PARM_icmp_capture_rate" ) ==  0   ) 
		{
                       	PARM_icmp_capture_rate =  cnt ;
			continue;
		}
		if ( strcmp(item, "PARM_icmp_2other_protos_rate" ) ==  0)
		{
			PARM_icmp_2other_protos_rate =  cnt ;
			continue;
		}
		if ( strcmp(item, "PARM_icmp_overall_weighting") == 0 )
		{ 
			PARM_icmp_overall_weighting  =  cnt ;
			continue;
		}
		if ( strcmp(item, "PARM_udpflood_rate")  == 0)
		{
			PARM_udpflood_rate  =  cnt ;
			continue;
		}
		if ( strcmp(item, "PARM_udpflood_rfc1918_rate") == 0 ) 
                {
			PARM_udpflood_rfc1918_rate =  cnt ;
			continue;
		}
		if ( strcmp(item, "PARM_udpflood_chksumlen_rate") == 0 )
		{ 
			PARM_udpflood_chksumlen_rate =  cnt ;
			continue;
		}
		if ( strcmp(item, "PARM_udpflood_overall_weighting") == 0 )
		{
			PARM_udpflood_overall_weighting  =  cnt ;
			continue;
		}
		if ( strcmp(item, "PARM_synflood_syn_rate")  == 0)            
                       {
                       	PARM_synflood_syn_rate =  cnt ;
			continue;
		}
		if ( strcmp(item, "PARM_synflood_syn_finrate") == 0) 
                {
			 PARM_synflood_syn_finrate  =  cnt ;
			continue;
		}
		if ( strcmp(item, "PARM_synflood_rfc1918_rate") == 0) 
		{
			PARM_synflood_rfc1918_rate =  cnt ;
			continue;
		}
		if ( strcmp(item, "PARM_synflood_overall_weighting") == 0 )
		{	
			PARM_synflood_overall_weighting =  cnt ;
			continue;
		}
		if ( strcmp(item, "PARM_rstflood_rst_rate") == 0) 
                {
 			PARM_rstflood_rst_rate  =  cnt ;
			continue;
		}
		if ( strcmp(item, "PARM_rstflood_rfc1918_rate" ) == 0 )
		{
			PARM_rstflood_rfc1918_rate  =  cnt ;
			continue;
		}
		if ( strcmp(item, "PARM_rstflood_overall_weighting" ) == 0 )
		{
			PARM_rstflood_overall_weighting  =  cnt ;
			continue;
		}
		if ( strcmp(item, "PARM_http_strong_flood_rate" ) == 0 )
                {
			PARM_http_strong_flood_rate =  cnt ;
			continue;
		}
		if ( strcmp(item, "PARM_http_verystrong_flood_rate") == 0 )
 		{ 
			PARM_http_verystrong_flood_rate  =  cnt ;
			continue;
		}
		if ( strcmp(item, "PARM_http_stronger_flood_rate")  == 0 )
                {  
			PARM_http_stronger_flood_rate =   cnt ;
			continue;
		}
		if ( strcmp(item, "PARM_http_rfc1918_rate" ) == 0) 
 		{ 
			PARM_http_rfc1918_rate =  cnt ;
			continue;
		}
		if ( strcmp(item, "PARM_http_chksumlen_rate") == 0) 
		{
			PARM_http_chksumlen_rate =  cnt ;
			continue;
		}
//
		if ( strcmp(item, "PARM_http_overall_weighting") ==  0) 
		{
			PARM_http_overall_weighting  =  cnt ;
			continue;
		}
//
//
		if ( strcmp(item, "PARM_stage1_capture_size") ==  0) 
		{
			PARM_stage1_capture_size  =  cnt ;
			continue;
		}
//
//
		if ( strcmp(item, "PARM_stage2_capture_size") ==  0) 
		{
			PARM_stage2_capture_size  =  cnt ;
			continue;
		}
//
//
		if ( strcmp(item, "PARM_stage3_capture_size") ==  0) 
		{
			PARM_stage3_capture_size  =  cnt ;
			continue;
		}
//
//
		if ( strcmp(item, "PARM_stage4_capture_size") ==  0) 
		{
			PARM_stage4_capture_size  =  cnt ;
			continue;
		}
//
//
		if ( strcmp(item, "PARM_stage5_capture_size") ==  0) 
		{
			PARM_stage5_capture_size  =  cnt ;
			continue;
		}
//
//
		if ( strcmp(item, "PARM_min_capture_sample") ==  0) 
		{
			PARM_min_capture_sample   =  cnt ;
			continue;
		}
//
//
//
		if ( strcmp(item, "PARM_pcap_loop_timeout") ==  0) 
		{
			PARM_pcap_loop_timeout   =  cnt ;
			continue;
		}
//
		if ( strcmp(item, "PARM_min_attack_src_addr") ==  0) 
		{
			PARM_min_attack_src_addr  =  cnt ;
			continue;
		}

//
//  Neither comment nor parm show error and exit 
//
//
		 fprintf(data_fptr,"Neither comment nor parm show error and exit \n");
		 fprintf(data_fptr,"error line: %50s\n", read_buffy);
		exit(1);

	}
        fclose(conf_fptr);
}

//   display_config()
// displays the setable parameters
void display_config()
{
DEBUGIT("DISPLAY_CONFIG")
// # planned capture against actual
	 fprintf(data_fptr," PARM_icmp_capture_rate \t \t \t %.2f \n", PARM_icmp_capture_rate );
	 fprintf(data_fptr," PARM_icmp_2other_protos_rate \t \t \t%.2f \n" ,  PARM_icmp_2other_protos_rate );
 	fprintf(data_fptr," PARM_icmp_overall_weighting \t \t \t %d \n" ,  PARM_icmp_overall_weighting )              ;

/* Static function to check for a ping flood attack */
	 fprintf(data_fptr," PARM_udpflood_rate  \t \t \t  %.2f \n", PARM_udpflood_rate  )                  ;
	 fprintf(data_fptr," PARM_udpflood_rfc1918_rate \t \t \t %.2f \n",  PARM_udpflood_rfc1918_rate  )          ;
	 fprintf(data_fptr," PARM_udpflood_chksumlen_rate  \t \t \t %.2f \n",      PARM_udpflood_chksumlen_rate )   ;
	 fprintf(data_fptr," PARM_udpflood_overall_weighting \t \t \t %d \n", PARM_udpflood_overall_weighting )    ;

	 fprintf(data_fptr," PARM_synflood_syn_rate \t \t \t %.2f \n", PARM_synflood_syn_rate )  ;
	 fprintf(data_fptr," PARM_synflood_syn_finrate \t \t \t  %.2f \n", PARM_synflood_syn_finrate )   ;
	 fprintf(data_fptr," PARM_synflood_rfc1918_rate \t \t \t %.2f \n"  , PARM_synflood_rfc1918_rate );
	 fprintf(data_fptr," PARM_synflood_overall_weighting \t \t \t %d \n", PARM_synflood_overall_weighting )      ;

	 fprintf(data_fptr," PARM_rstflood_rst_rate \t \t \t %.2f \n" ,  PARM_rstflood_rst_rate  );
	 fprintf(data_fptr," PARM_rstflood_rfc1918_rate \t \t \t %.2f \n", PARM_rstflood_rfc1918_rate );
	 fprintf(data_fptr," PARM_rstflood_overall_weighting  \t \t \t %d \n" ,  PARM_rstflood_overall_weighting ) ;

/* Static function to check for a HTTP flood attack. */
	 fprintf(data_fptr," PARM_http_strong_flood_rate \t \t \t %.2f \n",  PARM_http_strong_flood_rate );
	 fprintf(data_fptr," PARM_http_verystrong_flood_rate \t \t \t %.2f \n" , PARM_http_verystrong_flood_rate);
	 fprintf(data_fptr," PARM_http_stronger_flood_rate \t \t \t %.2f \n" , PARM_http_stronger_flood_rate )  ;
	 fprintf(data_fptr," PARM_http_rfc1918_rate \t \t \t  %.2f \n",                     PARM_http_rfc1918_rate );
	 fprintf(data_fptr," PARM_http_chksumlen_rate \t \t \t  %.2f \n",     PARM_http_chksumlen_rate );
	 fprintf(data_fptr," PARM_http_overall_weighting \t \t \t %d \n",   PARM_http_overall_weighting );

	 fprintf(data_fptr," PARM_stage1_capture_size \t \t \t %d \n", PARM_stage1_capture_size  );
	 fprintf(data_fptr," PARM_stage2_capture_size \t \t \t %d \n", PARM_stage2_capture_size  );
	 fprintf(data_fptr," PARM_stage3_capture_size \t \t \t %d \n", PARM_stage3_capture_size  );
	 fprintf(data_fptr," PARM_stage4_capture_size \t \t \t %d \n", PARM_stage4_capture_size  );
	 fprintf(data_fptr," PARM_stage5_capture_size \t \t \t %d \n", PARM_stage5_capture_size  );
	 fprintf(data_fptr," PARM_min_capture_sample \t \t \t %d \n" , PARM_min_capture_sample);
	 fprintf(data_fptr," PARM_pcap_loop_timeout \t \t \t %d \n" , PARM_pcap_loop_timeout);
	 fprintf(data_fptr," PARM_min_attack_src_addr \t \t \t %d \n",  PARM_min_attack_src_addr);

}


/* Main thread */
int main(int argc, char **argv)
{
DEBUGIT("MAIN")
	int n = 0;
	int is_tcp = 0;
        int is_udp = 0;
	int is_icmp = 0;
        int no_data_file = 0;
	
	strcpy(filter_exp, "ip"   );
	/* check for capture device name on command-line */
	if (argc == 2) 
    		dev = argv[1];
  	else if (argc == 3) 
  	{
    		dev = argv[1];
		strcpy(filter_exp, argv[2]);
 	}
  	else
  	{
  		fprintf(stderr, "error: unrecognized command-line options\n\n");
    		print_app_usage();
    		exit(EXIT_FAILURE);
 	}

	/* Open a data log file */
	data_fptr = fopen(DATA_FILE, "a+");

	if (data_fptr == NULL)
	{
		data_fptr = stdout;
		no_data_file = 1;
	}
       	fprintf(data_fptr, "--------------------------**OBESSIUS STARTED**");
       	time(&current);
       	sprintf(tdate_buf, "%s", ctime(&current));

       	fprintf(data_fptr, " TIME: %s", tdate_buf);
       	fprintf(data_fptr, "------------------------------  \n");
       	fprintf(data_fptr, "--------------------------Current Settings----------------------------------  \n");
        get_config();
        display_config();
       	fprintf(data_fptr, "----------------------------------------------------------------------------  \n");

	/* Main loop */
	while (1)
        {
		/* Get the current timestamp for attack identification */
        	time(&current);
        	sprintf(tdate_buf, "%s", ctime(&current));

		/* Check if management script has cleared out data file */
		if (access(DATA_FILE, W_OK) != 0)
        		data_fptr = fopen(DATA_FILE, "a+");

		handle = pcap_open_live(dev, SNAP_LEN_HDR, 1, 100, errbuf);

		if (handle == NULL)
		{
			fprintf(data_fptr, "Couldn't open device %s: %s EXITING...\n", dev, errbuf);
			sleep(FIVE_SECS);
			continue;
		}

        	if (pcap_build_filter() == -1)
		{
			fprintf(data_fptr, "Catastrophic: Can't use this filter.. must exit\n");
			exit(EXIT_FAILURE);
		}

		/* Reset the counts */
		reset_counts();

        	/* Add obtain a two digit unique id for probe */
        	add_probe_unqid();

		/* Initialise the blacklist */ 
		init_blacklist();

		/* Check auxiliary blacklist age */
		init_aux_blacklist();

        	fprintf(data_fptr, "-------------------------**START OF ITERATION**-----------------------------  \n");
        	fprintf(data_fptr, "TIMESTAMP FOR THIS ITERATION is %s", tdate_buf);
        	fprintf(data_fptr, "----------------------------------------------------------------------------  \n");
        	fprintf(data_fptr, "Stage 1 Bucket Processing..........\n") ;
  		fprintf(data_fptr, "Find the top talking /24\n") ;
  		if (process_buckets() == -1)
			continue;
  	
		fprintf(data_fptr, "There are %d /24 in the bucket which qualify for the top %d per cent count\n", top_24_count, (int)(100 *TOP_PC_DEC)); 
  		fprintf(data_fptr, "Capture complete. read %i \n", count  )  ;                   /* packet counter */
  		fprintf(data_fptr, "----------------------------------------------------------------------------  \n") ;

        	fprintf(data_fptr, "Processing data from top buckets\n") ;
        	fprintf(data_fptr, "----------------------------------------------------------------------------  \n") ;
	
		/* This processing from this point forward is looped to manage process top_pc_count
		number of addresses. */
		for (top_24_pc_no = 0; top_24_pc_no < top_24_count; top_24_pc_no++)
		{
			/* Specific resets */
			udp_cnt = 0;
			is_tcp = 0;
			is_udp = 0;
			is_icmp = 0;
			max_port = 0;
			stage3_count = 0;
			time(&current);

			if (process_packets() != 0)
			{
				output_seperator();
				continue;
			}
			else if (min_threshold_met(2) == 0)
				continue;
	
                	fprintf(data_fptr, "Top talking ip from /24 bucket %d of %d: Max packet count %s : %i \n", top_24_pc_no + 1, top_24_count,
                	inet_ntoa(print_ip) , max_packet_cnt );


//STAGE 3
// Now we have found the dest address of an attack 
// try and identify the protocol         
			reset_counts();
                	fprintf(data_fptr, "Stage 3 Find top protocol for this host in this bucket..........\n") ;

                	sprintf( filter_exp ,"dst host  %s ", inet_ntoa(  print_ip) );
			fprintf(data_fptr, "DST HOST: Apply filter  :%s  \n",  filter_exp  );

                	/* open capture device */
                	handle = pcap_open_live(dev, SNAP_LEN_HDR, 1, 10, errbuf);
                	if (handle == NULL)
                	{
                		fprintf(stderr, "Couldn't open file, %s: %s, continuing..\n", dev, errbuf);
                		output_seperator();
				continue;
        		}

			
                	/* Compile the filter expression */
                	if (pcap_build_filter() == -1)
			{
				output_seperator();
				continue;
			}

                	/* Set an alarm for PARM_pcap_loop_timeout seconds and setup
                	 * the handler, (to prevent hanging issues) */
                	alarm(PARM_pcap_loop_timeout);
                	signal (SIGALRM, SigAlrmHandlerCount);

			/* Open unique dumpfile */
			unqfnam = tempnam(TMPDIR, PREFIX);

			/* Capture stage3 in case of pingflood. */
			if (handle != NULL && unqfnam != NULL)
				dumpd = pcap_dump_open(handle, unqfnam);

            		/* Now we can set our callback function
        		*/
           		pcap_loop(handle, (int) PARM_stage3_capture_size,  get_ip_attack, NULL);

			if (timeout == 0)
                	{
                    		/* cleanup */
                    		alarm(0);
                    		pcap_freecode(&fp);
                    		pcap_close(handle);
                	}
                	else
                    		timeout = 0;
        
			/* Close dump file. */
                	if (dumpd != NULL)
                        	pcap_dump_close(dumpd);

			/* Check enough packets received. */
        	        if (min_threshold_met(3) == 0)
                	{
				remove_pcap();
                        	continue;
                	}

			/* Report highest protocol count for this iteration */
                	if ((tcp_cnt > icmp_cnt) &&  (tcp_cnt > udp_cnt))
			{
                		fprintf(data_fptr, "Top protocol from /24 bucket %d of %d is tcp\n", top_24_pc_no + 1, top_24_count);
				strcpy(filter_proto,"TCP");
        	                is_tcp = 1;
				remove_pcap();
			}
                	if ((udp_cnt > icmp_cnt) &&  (udp_cnt > tcp_cnt))
			{
				fprintf(data_fptr, "Top protocol from /24 bucket %d of %d is udp\n", top_24_pc_no + 1, top_24_count);
                        	strcpy(filter_proto,"UDP");
                        	is_udp = 1;
				remove_pcap();
			}
			if ((icmp_cnt > tcp_cnt) &&  (icmp_cnt > udp_cnt))
			{
                        	fprintf(data_fptr, "Top protocol from /24 bucket %d of %d is icmp\n", top_24_pc_no + 1, top_24_count);
                        	is_icmp = 1;
				if (is_pingflood() == 0)
				{
					calc_bandwidth(NULL, NULL, 0);
				}
				else if (unqfnam != NULL)
					free(unqfnam);

				output_seperator();
				/* Update the blacklist file for this ping iteration. */
				update_blacklist_file();
				continue;
			}
		

//STAGE 4
// Now we have found the address and  protocol of an attack 
// try and identify to a specific port   
                	reset_counts();

			/* Branch for various protocols.
			* This following is for TCP and UDP protocols.
			*/
                	fprintf(data_fptr, "Stage 4 Find top port for this host in this bucket..........\n") ;
                	
			if (is_tcp == 1)
				sprintf(filter_exp ,"tcp and dst host %s ", inet_ntoa(print_ip));
			else if (is_udp == 1)
				sprintf(filter_exp ,"udp and dst host %s ", inet_ntoa(print_ip));
			else
			{
				fprintf(data_fptr, "***Protocol not recognised, continuing..***\n");
				remove_pcap();
				output_seperator();
				continue;
			}

			/* open capture device */
	        	handle = pcap_open_live(dev, SNAP_LEN_HDR, 1, 10, errbuf);
                	if (handle == NULL)
                	{
				fprintf(stderr, "Couldn't open file, %s: %s, continuing..\n", dev, errbuf);
				output_seperator();
				continue;
			}

			/* compile the filter expression */
			if (pcap_build_filter() == -1)
			{
				output_seperator();
				continue;
			}

			/* Set an alarm for PARM_pcap_loop_timeout seconds and setup 
			* the handler, (to prevent hanging issues) */
			alarm(PARM_pcap_loop_timeout);
			signal (SIGALRM, SigAlrmHandler);

			pcap_loop(handle, (int) PARM_stage4_capture_size, get_port_attack, NULL);

			if (timeout == 0)
        	        {
				/* cleanup */
				alarm(0);
				pcap_freecode(&fp);
				pcap_close(handle);
                	}
                	else
				timeout = 0;

			/* Check count. */
        	        if (min_threshold_met(4) == 0)
                	        continue;

        		sprintf(filter_port ," and dst port %i ", max_port);

			fprintf(data_fptr, "Top port from /24 bucket %d of %d is port no.%d with a count of %d\n", top_24_pc_no + 1, top_24_count, max_port, max_port_cnt);

			reset_counts();

//STAGE 5
// Now we have found the address, protocol, port of a specific attack 
// try and match it to a siginature 
			fprintf(data_fptr, "Stage 5 Analyse this attack..........\n");
	
			if (is_tcp == 1)
			{
				sprintf( filter_exp ,"tcp and dst host %s  %s", inet_ntoa(print_ip), filter_port);
				callback = get_tcp_attack;
			}
			else if (is_udp == 1)
			{
				sprintf( filter_exp ,"udp and dst host %s  %s", inet_ntoa(print_ip), filter_port);
				callback = get_udp_attack;
			}

			fprintf(data_fptr, "DST HOST & PORT Apply filter  :%s  \n",  filter_exp);

			/* Write print_ip into max_ip_addr for further use in 
		 	* this iteration as TCP processing reuses the table */
			sprintf(max_ip_addr, "%s", inet_ntoa(print_ip));
		
			/* open capture device */
                	handle = pcap_open_live(dev, SNAP_LEN_FULL, 1, 10, errbuf);
                	if (handle == NULL)
                	{
                        	fprintf(stderr, "Couldn't open file, %s: %s, continuing..\n", dev, errbuf);
                        	output_seperator();
				continue;
                	}

			/* compile the filter expression */
                	if (pcap_build_filter() == -1)
			{
				output_seperator();
				continue;
			}

			/* Set an alarm for PARM_pcap_loop_timeout seconds and setup
                 	* the handler, (to prevent hanging issues) */
                	alarm(PARM_pcap_loop_timeout);
                	signal (SIGALRM, SigAlrmHandler);

			/* Open and write packets to a temporary log file if TCP or UDP */
			if (is_tcp == 1 || is_udp == 1)
			{
				unqfnam = tempnam(TMPDIR, PREFIX);
				if (handle != NULL && unqfnam != NULL)
					dumpd = pcap_dump_open(handle, unqfnam);
			}

			pcap_loop(handle, (int) PARM_stage5_capture_size, callback, NULL); 

                	if (timeout == 0)
                	{
                    		/* cleanup */
                    		alarm(0);
                    		pcap_freecode(&fp);
                    		pcap_close(handle);
                	}
                	else
                    		timeout = 0;

			/* Close dump file. */
			if (dumpd != NULL && (is_tcp == 1 || is_udp == 1))
                		pcap_dump_close(dumpd);

			/* Check enough packets received. */
			if (min_threshold_met(5) == 0)
			{
				remove_pcap();
				continue;
			}

			/* If only one source address  */
// OBV7 		Early versions ignored all attacks If only one source address  
// OBV7 		for the attack (DDOS not DoS)     
// OBV7 		makes this check optional controlled parms        
			if (max_num_srcs <= PARM_min_attack_src_addr )
			{
				update_blacklist_file();
				calc_bandwidth(NULL, NULL, 0);
				fprintf(data_fptr, "NOT an Obessius recognised DDOS attack.\n");
				output_seperator();
				fflush(data_fptr);
				continue;
			}
			
			/* More than one src address, check for synflood, resetflood or 
			 * httpflood attacks if the protccol is TCP. */
			if (is_tcp == 1)
			{
				if (is_synflood() == 1)
					alert = 1;
				else if (is_resetflood() == 0)
					alert = 1;
				if (is_httpflood() == 0)
					alert = 1;

				if (!alert)
				{
					calc_bandwidth(NULL, NULL, 0);
				}
			}
			/* Check for a udpflood if the protocol is UDP. */
			else if (is_udp == 1)
			{
				if (is_udpflood() == 0)
				{
					calc_bandwidth(NULL, NULL, 0);
				}
			}
			output_seperator();
			
			/* Free the filename string */
			if (unqfnam != NULL)
				free(unqfnam);

			/* Update the blacklist file this iteration. */
			update_blacklist_file();
			fflush(data_fptr);
		} /* End of top pc loop */
		/* Clear up the subnet data for next iteration. */
		memset(top_24_pc, 0, TOP_PC_SIZE);
		top_24_count = 0;
		reset_counts();
		sleep(FIVE_SECS);
	}/* End of while loop */

        /* Close file if opened. */
        if (!no_data_file)
            fclose(data_fptr);

	return 0;
}
